/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.document;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;

@SdkInternalApi
public final class JsonStringFormatHelper {
    private JsonStringFormatHelper() {
    }

    public static String stringValue(JsonNode jsonNode) {
        if (jsonNode.isArray()) {
            return StreamSupport.stream(jsonNode.asArray().spliterator(), false).map(JsonStringFormatHelper::stringValue).collect(Collectors.joining(",", "[", "]"));
        }
        if (jsonNode.isObject()) {
            return JsonStringFormatHelper.mapToString(jsonNode);
        }
        return jsonNode.isString() ? "\"" + JsonStringFormatHelper.addEscapeCharacters(jsonNode.text()) + "\"" : jsonNode.toString();
    }

    public static String addEscapeCharacters(String input) {
        StringBuilder output = null;
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (JsonStringFormatHelper.needsEscaping(ch)) {
                if (output == null) {
                    output = JsonStringFormatHelper.initializeStringBuilder(input, i);
                }
                JsonStringFormatHelper.appendEscapeChar(output, ch);
                continue;
            }
            if (output == null) continue;
            output.append(ch);
        }
        return output == null ? input : output.toString();
    }

    private static boolean needsEscaping(char ch) {
        return Character.isISOControl(ch) || ch == '\"' || ch == '\\';
    }

    private static StringBuilder initializeStringBuilder(String input, int position) {
        StringBuilder builder = new StringBuilder(input.length() + 16);
        builder.append(input, 0, position);
        return builder;
    }

    private static void appendEscapeChar(StringBuilder output, char ch) {
        switch (ch) {
            case '\\': {
                output.append("\\\\");
                break;
            }
            case '\n': {
                output.append("\\n");
                break;
            }
            case '\r': {
                output.append("\\r");
                break;
            }
            case '\t': {
                output.append("\\t");
                break;
            }
            case '\f': {
                output.append("\\f");
                break;
            }
            case '\"': {
                output.append("\\\"");
                break;
            }
            default: {
                if (Character.isISOControl(ch)) {
                    output.append(String.format("\\u%04X", ch));
                    break;
                }
                output.append(ch);
            }
        }
    }

    private static String mapToString(JsonNode jsonNode) {
        Map value = jsonNode.asObject();
        if (value.isEmpty()) {
            return "{}";
        }
        StringBuilder output = new StringBuilder();
        output.append("{");
        value.forEach((k, v) -> output.append("\"").append((String)k).append("\":").append(JsonStringFormatHelper.stringValue(v)).append(","));
        output.setCharAt(output.length() - 1, '}');
        return output.toString();
    }
}

