/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.conditional;

import java.util.Collections;
import java.util.HashMap;
import java.util.function.UnaryOperator;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.QueryConditionalKeyValues;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public class BetweenConditional
implements QueryConditional {
    private static final UnaryOperator<String> EXPRESSION_OTHER_VALUE_KEY_MAPPER = k -> ":AMZN_MAPPED_" + EnhancedClientUtils.cleanAttributeName(k) + "2";
    private final Key key1;
    private final Key key2;

    public BetweenConditional(Key key1, Key key2) {
        this.key1 = key1;
        this.key2 = key2;
    }

    @Override
    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        QueryConditionalKeyValues queryConditionalKeyValues1 = QueryConditionalKeyValues.from(this.key1, tableSchema, indexName);
        QueryConditionalKeyValues queryConditionalKeyValues2 = QueryConditionalKeyValues.from(this.key2, tableSchema, indexName);
        if (queryConditionalKeyValues1.sortValue().equals((Object)AttributeValues.nullAttributeValue()) || queryConditionalKeyValues2.sortValue().equals((Object)AttributeValues.nullAttributeValue())) {
            throw new IllegalArgumentException("Attempt to query using a 'between' condition operator where one of the items has a null sort key.");
        }
        String partitionKeyToken = EnhancedClientUtils.keyRef(queryConditionalKeyValues1.partitionKey());
        String partitionValueToken = EnhancedClientUtils.valueRef(queryConditionalKeyValues1.partitionKey());
        String sortKeyToken = EnhancedClientUtils.keyRef(queryConditionalKeyValues1.sortKey());
        String sortKeyValueToken1 = EnhancedClientUtils.valueRef(queryConditionalKeyValues1.sortKey());
        String sortKeyValueToken2 = (String)EXPRESSION_OTHER_VALUE_KEY_MAPPER.apply(queryConditionalKeyValues2.sortKey());
        String queryExpression = String.format("%s = %s AND %s BETWEEN %s AND %s", partitionKeyToken, partitionValueToken, sortKeyToken, sortKeyValueToken1, sortKeyValueToken2);
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        expressionAttributeValues.put(partitionValueToken, queryConditionalKeyValues1.partitionValue());
        expressionAttributeValues.put(sortKeyValueToken1, queryConditionalKeyValues1.sortValue());
        expressionAttributeValues.put(sortKeyValueToken2, queryConditionalKeyValues2.sortValue());
        HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
        expressionAttributeNames.put(partitionKeyToken, queryConditionalKeyValues1.partitionKey());
        expressionAttributeNames.put(sortKeyToken, queryConditionalKeyValues1.sortKey());
        return Expression.builder().expression(queryExpression).expressionValues(Collections.unmodifiableMap(expressionAttributeValues)).expressionNames(expressionAttributeNames).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetweenConditional that = (BetweenConditional)o;
        if (this.key1 != null ? !this.key1.equals(that.key1) : that.key1 != null) {
            return false;
        }
        return this.key2 != null ? this.key2.equals(that.key2) : that.key2 == null;
    }

    public int hashCode() {
        int result = this.key1 != null ? this.key1.hashCode() : 0;
        result = 31 * result + (this.key2 != null ? this.key2.hashCode() : 0);
        return result;
    }
}

