/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.DateTimeException;
import java.time.LocalTime;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.InstantAsStringAttributeConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class LocalTimeAttributeConverter
implements AttributeConverter<LocalTime> {
    private static final Visitor VISITOR = new Visitor();

    private LocalTimeAttributeConverter() {
    }

    public static LocalTimeAttributeConverter create() {
        return new LocalTimeAttributeConverter();
    }

    @Override
    public EnhancedType<LocalTime> type() {
        return EnhancedType.of(LocalTime.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(LocalTime input) {
        return (AttributeValue)AttributeValue.builder().s(input.toString()).build();
    }

    @Override
    public LocalTime transformTo(AttributeValue input) {
        if (input.s() != null) {
            return EnhancedAttributeValue.fromString(input.s()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<LocalTime> {
        private Visitor() {
            super(LocalTime.class, InstantAsStringAttributeConverter.class);
        }

        @Override
        public LocalTime convertString(String value) {
            try {
                return LocalTime.parse(value);
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

