/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.math.BigDecimal;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.BigDecimalStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class BigDecimalAttributeConverter
implements AttributeConverter<BigDecimal> {
    private static final Visitor VISITOR = new Visitor();
    private static final BigDecimalStringConverter STRING_CONVERTER = BigDecimalStringConverter.create();

    private BigDecimalAttributeConverter() {
    }

    public static BigDecimalAttributeConverter create() {
        return new BigDecimalAttributeConverter();
    }

    @Override
    public EnhancedType<BigDecimal> type() {
        return EnhancedType.of(BigDecimal.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(BigDecimal input) {
        return (AttributeValue)AttributeValue.builder().n(STRING_CONVERTER.toString(input)).build();
    }

    @Override
    public BigDecimal transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<BigDecimal> {
        private Visitor() {
            super(BigDecimal.class, BigDecimalAttributeConverter.class);
        }

        @Override
        public BigDecimal convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public BigDecimal convertNumber(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

