/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeVisitor;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public class JsonNodeToAttributeValueMapConverter
implements JsonNodeVisitor<AttributeValue> {
    private static final JsonNodeToAttributeValueMapConverter INSTANCE = new JsonNodeToAttributeValueMapConverter();

    private JsonNodeToAttributeValueMapConverter() {
    }

    public static JsonNodeToAttributeValueMapConverter instance() {
        return INSTANCE;
    }

    public AttributeValue visitNull() {
        return AttributeValue.fromNul((Boolean)true);
    }

    public AttributeValue visitBoolean(boolean bool) {
        return (AttributeValue)AttributeValue.builder().bool(Boolean.valueOf(bool)).build();
    }

    public AttributeValue visitNumber(String number) {
        return (AttributeValue)AttributeValue.builder().n(number).build();
    }

    public AttributeValue visitString(String string) {
        return (AttributeValue)AttributeValue.builder().s(string).build();
    }

    public AttributeValue visitArray(List<JsonNode> array) {
        return (AttributeValue)AttributeValue.builder().l((Collection)array.stream().map(node -> (AttributeValue)node.visit((JsonNodeVisitor)this)).collect(Collectors.toList())).build();
    }

    public AttributeValue visitObject(Map<String, JsonNode> object) {
        return (AttributeValue)AttributeValue.builder().m((Map)object.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (AttributeValue)((JsonNode)entry.getValue()).visit((JsonNodeVisitor)this), (left, right) -> left, LinkedHashMap::new))).build();
    }

    public AttributeValue visitEmbeddedObject(Object embeddedObject) {
        throw new UnsupportedOperationException("Embedded objects are not supported within Document types.");
    }
}

