/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.document;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;

@SdkInternalApi
public final class JsonStringFormatHelper {
    private JsonStringFormatHelper() {
    }

    public static String stringValue(JsonNode jsonNode) {
        if (jsonNode.isArray()) {
            return StreamSupport.stream(jsonNode.asArray().spliterator(), false).map(JsonStringFormatHelper::stringValue).collect(Collectors.joining(",", "[", "]"));
        }
        if (jsonNode.isObject()) {
            return JsonStringFormatHelper.mapToString(jsonNode);
        }
        return jsonNode.isString() ? "\"" + JsonStringFormatHelper.addEscapeCharacters(jsonNode.text()) + "\"" : jsonNode.toString();
    }

    public static String addEscapeCharacters(String input) {
        StringBuilder output = new StringBuilder();
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case '\\': {
                    output.append("\\\\");
                    continue block8;
                }
                case '\n': {
                    output.append("\\n");
                    continue block8;
                }
                case '\r': {
                    output.append("\\r");
                    continue block8;
                }
                case '\t': {
                    output.append("\\t");
                    continue block8;
                }
                case '\f': {
                    output.append("\\f");
                    continue block8;
                }
                case '\"': {
                    output.append("\\\"");
                    continue block8;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        output.append(String.format("\\u%04X", ch));
                        continue block8;
                    }
                    output.append(ch);
                }
            }
        }
        return output.toString();
    }

    private static String mapToString(JsonNode jsonNode) {
        Map value = jsonNode.asObject();
        if (value.isEmpty()) {
            return "{}";
        }
        StringBuilder output = new StringBuilder();
        output.append("{");
        value.forEach((k, v) -> output.append("\"").append((String)k).append("\":").append(JsonStringFormatHelper.stringValue(v)).append(","));
        output.setCharAt(output.length() - 1, '}');
        return output.toString();
    }
}

