/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.Either;
import software.amazon.awssdk.utils.FunctionalUtils;

@SdkInternalApi
public class LambdaToMethodBridgeBuilder<T> {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private final Class<T> lambdaType;
    private String lambdaMethodName;
    private Class<?> postEraseLambdaReturnType;
    private Class<?>[] postEraseLambdaParameters;
    private Class<?> preEraseLambdaReturnType;
    private Class<?>[] preEraseLambdaParameters;
    private Either<Method, Constructor<?>> targetMethod;

    private LambdaToMethodBridgeBuilder(Class<T> lambdaType) {
        this.lambdaType = lambdaType;
    }

    public static <T> LambdaToMethodBridgeBuilder<T> create(Class<T> lambdaType) {
        return new LambdaToMethodBridgeBuilder<T>(lambdaType);
    }

    public LambdaToMethodBridgeBuilder<T> lambdaMethodName(String lambdaMethodName) {
        this.lambdaMethodName = lambdaMethodName;
        return this;
    }

    public LambdaToMethodBridgeBuilder<T> runtimeLambdaSignature(Class<?> returnType, Class<?> ... parameters) {
        this.postEraseLambdaReturnType = returnType;
        this.postEraseLambdaParameters = (Class[])parameters.clone();
        return this;
    }

    public LambdaToMethodBridgeBuilder<T> compileTimeLambdaSignature(Class<?> returnType, Class<?> ... parameters) {
        this.preEraseLambdaReturnType = returnType;
        this.preEraseLambdaParameters = (Class[])parameters.clone();
        return this;
    }

    public LambdaToMethodBridgeBuilder<T> targetMethod(Method method) {
        this.targetMethod = Either.left((Object)method);
        return this;
    }

    public LambdaToMethodBridgeBuilder<T> targetMethod(Constructor<?> method) {
        this.targetMethod = Either.right(method);
        return this;
    }

    public T build() {
        try {
            MethodHandle targetMethodHandle = (MethodHandle)this.targetMethod.map(m -> (MethodHandle)FunctionalUtils.invokeSafely(() -> LOOKUP.unreflect((Method)m)), c -> (MethodHandle)FunctionalUtils.invokeSafely(() -> LOOKUP.unreflectConstructor((Constructor<?>)c)));
            return this.lambdaType.cast(LambdaMetafactory.metafactory(LOOKUP, this.lambdaMethodName, MethodType.methodType(this.lambdaType), MethodType.methodType(this.postEraseLambdaReturnType, this.postEraseLambdaParameters), targetMethodHandle, MethodType.methodType(this.preEraseLambdaReturnType, this.preEraseLambdaParameters)).getTarget().invoke());
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to generate method handle.", e);
        }
    }
}

