/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class ByteBufferAttributeConverter
implements AttributeConverter<ByteBuffer> {
    private static final Visitor VISITOR = new Visitor();

    private ByteBufferAttributeConverter() {
    }

    public static ByteBufferAttributeConverter create() {
        return new ByteBufferAttributeConverter();
    }

    @Override
    public EnhancedType<ByteBuffer> type() {
        return EnhancedType.of(ByteBuffer.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.B;
    }

    @Override
    public AttributeValue transformFrom(ByteBuffer input) {
        return (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteBuffer((ByteBuffer)input)).build();
    }

    @Override
    public ByteBuffer transformTo(AttributeValue input) {
        if (input.b() != null) {
            return EnhancedAttributeValue.fromBytes(input.b()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<ByteBuffer> {
        private Visitor() {
            super(ByteBuffer.class, ByteBufferAttributeConverter.class);
        }

        @Override
        public ByteBuffer convertBytes(SdkBytes value) {
            return value.asByteBuffer();
        }
    }
}

