/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
@ThreadSafe
public final class Page<T> {
    private final List<T> items;
    private final Map<String, AttributeValue> lastEvaluatedKey;

    private Page(List<T> items, Map<String, AttributeValue> lastEvaluatedKey) {
        this.items = items;
        this.lastEvaluatedKey = lastEvaluatedKey;
    }

    public static <T> Page<T> create(List<T> items, Map<String, AttributeValue> lastEvaluatedKey) {
        return new Page<T>(items, lastEvaluatedKey);
    }

    public static <T> Page<T> create(List<T> items) {
        return new Page<T>(items, null);
    }

    public List<T> items() {
        return this.items;
    }

    public Map<String, AttributeValue> lastEvaluatedKey() {
        return this.lastEvaluatedKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        if (this.items != null ? !this.items.equals(page.items) : page.items != null) {
            return false;
        }
        return this.lastEvaluatedKey != null ? this.lastEvaluatedKey.equals(page.lastEvaluatedKey) : page.lastEvaluatedKey == null;
    }

    public int hashCode() {
        int result = this.items != null ? this.items.hashCode() : 0;
        result = 31 * result + (this.lastEvaluatedKey != null ? this.lastEvaluatedKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"Page").add("lastEvaluatedKey", this.lastEvaluatedKey).add("items", this.items).build();
    }
}

