/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.update;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.UpdateBehaviorTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.UpdateBehavior;
import software.amazon.awssdk.enhanced.dynamodb.update.RemoveAction;
import software.amazon.awssdk.enhanced.dynamodb.update.SetAction;
import software.amazon.awssdk.enhanced.dynamodb.update.UpdateExpression;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
public final class UpdateExpressionUtils {
    private UpdateExpressionUtils() {
    }

    public static String keyRef(String key) {
        return "#AMZN_MAPPED_" + EnhancedClientUtils.cleanAttributeName(key);
    }

    public static String valueRef(String value) {
        return ":AMZN_MAPPED_" + EnhancedClientUtils.cleanAttributeName(value);
    }

    public static String ifNotExists(String key, String initValue) {
        return "if_not_exists(" + UpdateExpressionUtils.keyRef(key) + ", " + UpdateExpressionUtils.valueRef(initValue) + ")";
    }

    public static UpdateExpression operationExpression(Map<String, AttributeValue> itemMap, TableMetadata tableMetadata, List<String> nonRemoveAttributes) {
        Map setAttributes = CollectionUtils.filterMap(itemMap, e -> !EnhancedClientUtils.isNullAttributeValue((AttributeValue)e.getValue()));
        UpdateExpression setAttributeExpression = UpdateExpression.builder().actions(UpdateExpressionUtils.setActionsFor(setAttributes, tableMetadata)).build();
        Map removeAttributes = CollectionUtils.filterMap(itemMap, e -> EnhancedClientUtils.isNullAttributeValue((AttributeValue)e.getValue()) && !nonRemoveAttributes.contains(e.getKey()));
        UpdateExpression removeAttributeExpression = UpdateExpression.builder().actions(UpdateExpressionUtils.removeActionsFor(removeAttributes)).build();
        return UpdateExpression.mergeExpressions(setAttributeExpression, removeAttributeExpression);
    }

    private static List<SetAction> setActionsFor(Map<String, AttributeValue> attributesToSet, TableMetadata tableMetadata) {
        return attributesToSet.entrySet().stream().map(entry -> UpdateExpressionUtils.setValue((String)entry.getKey(), (AttributeValue)entry.getValue(), UpdateBehaviorTag.resolveForAttribute((String)entry.getKey(), tableMetadata))).collect(Collectors.toList());
    }

    private static List<RemoveAction> removeActionsFor(Map<String, AttributeValue> attributesToSet) {
        return attributesToSet.entrySet().stream().map(entry -> UpdateExpressionUtils.remove((String)entry.getKey())).collect(Collectors.toList());
    }

    private static RemoveAction remove(String attributeName) {
        return RemoveAction.builder().path(UpdateExpressionUtils.keyRef(attributeName)).expressionNames(Collections.singletonMap(UpdateExpressionUtils.keyRef(attributeName), attributeName)).build();
    }

    private static SetAction setValue(String attributeName, AttributeValue value, UpdateBehavior updateBehavior) {
        return SetAction.builder().path(UpdateExpressionUtils.keyRef(attributeName)).value(UpdateExpressionUtils.behaviorBasedValue(updateBehavior).apply(attributeName)).expressionNames(UpdateExpressionUtils.expressionNamesFor(attributeName)).expressionValues(Collections.singletonMap(UpdateExpressionUtils.valueRef(attributeName), value)).build();
    }

    private static Function<String, String> behaviorBasedValue(UpdateBehavior updateBehavior) {
        switch (updateBehavior) {
            case WRITE_ALWAYS: {
                return v -> UpdateExpressionUtils.valueRef(v);
            }
            case WRITE_IF_NOT_EXISTS: {
                return k -> UpdateExpressionUtils.ifNotExists(k, k);
            }
        }
        throw new IllegalArgumentException("Unsupported update behavior '" + (Object)((Object)updateBehavior) + "'");
    }

    private static Map<String, String> expressionNamesFor(String ... attributeNames) {
        return Arrays.stream(attributeNames).collect(Collectors.toMap(UpdateExpressionUtils::keyRef, Function.identity()));
    }
}

