/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;

@SdkPublicApi
public class TransactUpdateItemEnhancedRequest<T> {
    private final T item;
    private final Boolean ignoreNulls;
    private final Expression conditionExpression;
    private final String returnValuesOnConditionCheckFailure;

    private TransactUpdateItemEnhancedRequest(Builder<T> builder) {
        this.item = ((Builder)builder).item;
        this.ignoreNulls = ((Builder)builder).ignoreNulls;
        this.conditionExpression = ((Builder)builder).conditionExpression;
        this.returnValuesOnConditionCheckFailure = ((Builder)builder).returnValuesOnConditionCheckFailure;
    }

    public static <T> Builder<T> builder(Class<? extends T> itemClass) {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return new Builder<T>().item(this.item).ignoreNulls(this.ignoreNulls).conditionExpression(this.conditionExpression).returnValuesOnConditionCheckFailure(this.returnValuesOnConditionCheckFailure);
    }

    public T item() {
        return this.item;
    }

    public Boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    public Expression conditionExpression() {
        return this.conditionExpression;
    }

    public ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure() {
        return ReturnValuesOnConditionCheckFailure.fromValue((String)this.returnValuesOnConditionCheckFailure);
    }

    public String returnValuesOnConditionCheckFailureAsString() {
        return this.returnValuesOnConditionCheckFailure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactUpdateItemEnhancedRequest that = (TransactUpdateItemEnhancedRequest)o;
        if (!Objects.equals(this.item, that.item)) {
            return false;
        }
        if (!Objects.equals(this.ignoreNulls, that.ignoreNulls)) {
            return false;
        }
        if (!Objects.equals(this.conditionExpression, that.conditionExpression)) {
            return false;
        }
        return Objects.equals(this.returnValuesOnConditionCheckFailure, that.returnValuesOnConditionCheckFailure);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.item);
        result = 31 * result + Objects.hashCode(this.ignoreNulls);
        result = 31 * result + Objects.hashCode(this.conditionExpression);
        result = 31 * result + Objects.hashCode(this.returnValuesOnConditionCheckFailure);
        return result;
    }

    public static final class Builder<T> {
        private T item;
        private Boolean ignoreNulls;
        private Expression conditionExpression;
        private String returnValuesOnConditionCheckFailure;

        private Builder() {
        }

        public Builder<T> ignoreNulls(Boolean ignoreNulls) {
            this.ignoreNulls = ignoreNulls;
            return this;
        }

        public Builder<T> conditionExpression(Expression conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public Builder<T> item(T item) {
            this.item = item;
            return this;
        }

        public Builder<T> returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure == null ? null : returnValuesOnConditionCheckFailure.toString();
            return this;
        }

        public Builder<T> returnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
            return this;
        }

        public TransactUpdateItemEnhancedRequest<T> build() {
            return new TransactUpdateItemEnhancedRequest(this);
        }
    }
}

