/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.extensions;

import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbExtensionContext;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.extensions.WriteModification;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableMetadata;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class AutoGeneratedTimestampRecordExtension
implements DynamoDbEnhancedClientExtension {
    private static final String CUSTOM_METADATA_KEY = "AutoGeneratedTimestampExtension:AutoGeneratedTimestampAttribute";
    private static final AutoGeneratedTimestampAttribute AUTO_GENERATED_TIMESTAMP_ATTRIBUTE = new AutoGeneratedTimestampAttribute();
    private final Clock clock;

    private AutoGeneratedTimestampRecordExtension() {
        this.clock = Clock.systemUTC();
    }

    private AutoGeneratedTimestampRecordExtension(Builder builder) {
        this.clock = builder.baseClock == null ? Clock.systemUTC() : builder.baseClock;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return AutoGeneratedTimestampRecordExtension.builder().baseClock(this.clock);
    }

    public static AutoGeneratedTimestampRecordExtension create() {
        return new AutoGeneratedTimestampRecordExtension();
    }

    @Override
    public WriteModification beforeWrite(DynamoDbExtensionContext.BeforeWrite context) {
        Collection customMetadataObject = context.tableMetadata().customMetadataObject(CUSTOM_METADATA_KEY, Collection.class).orElse(null);
        if (customMetadataObject == null) {
            return WriteModification.builder().build();
        }
        HashMap<String, AttributeValue> itemToTransform = new HashMap<String, AttributeValue>(context.items());
        customMetadataObject.forEach(key -> this.insertTimestampInItemToTransform((Map<String, AttributeValue>)itemToTransform, (String)key, context.tableSchema().converterForAttribute(key)));
        return WriteModification.builder().transformedItem(Collections.unmodifiableMap(itemToTransform)).build();
    }

    private void insertTimestampInItemToTransform(Map<String, AttributeValue> itemToTransform, String key, AttributeConverter converter) {
        itemToTransform.put(key, converter.transformFrom(this.clock.instant()));
    }

    private static class AutoGeneratedTimestampAttribute
    implements StaticAttributeTag {
        private AutoGeneratedTimestampAttribute() {
        }

        @Override
        public <R> void validateType(String attributeName, EnhancedType<R> type, AttributeValueType attributeValueType) {
            Validate.notNull(type, (String)"type is null", (Object[])new Object[0]);
            Validate.notNull(type.rawClass(), (String)"rawClass is null", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)attributeValueType), (String)"attributeValueType is null", (Object[])new Object[0]);
            if (!type.rawClass().equals(Instant.class)) {
                throw new IllegalArgumentException(String.format("Attribute '%s' of Class type %s is not a suitable Java Class type to be used as a Auto Generated Timestamp attribute. Only java.time.Instant Class type is supported.", attributeName, type.rawClass()));
            }
        }

        @Override
        public Consumer<StaticTableMetadata.Builder> modifyMetadata(String attributeName, AttributeValueType attributeValueType) {
            return metadata -> metadata.addCustomMetadataObject(AutoGeneratedTimestampRecordExtension.CUSTOM_METADATA_KEY, Collections.singleton(attributeName)).markAttributeAsKey(attributeName, attributeValueType);
        }
    }

    public static final class Builder {
        private Clock baseClock;

        private Builder() {
        }

        public Builder baseClock(Clock clock) {
            this.baseClock = clock;
            return this;
        }

        public AutoGeneratedTimestampRecordExtension build() {
            return new AutoGeneratedTimestampRecordExtension(this);
        }
    }

    public static final class AttributeTags {
        private AttributeTags() {
        }

        public static StaticAttributeTag autoGeneratedTimestampAttribute() {
            return AUTO_GENERATED_TIMESTAMP_ATTRIBUTE;
        }
    }
}

