/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkInternalApi
public interface DatabaseOperation<RequestT, ResponseT, ResultT> {
    public RequestT generateRequest(DynamoDbEnhancedClientExtension var1);

    public Function<RequestT, ResponseT> serviceCall(DynamoDbClient var1);

    public Function<RequestT, CompletableFuture<ResponseT>> asyncServiceCall(DynamoDbAsyncClient var1);

    public ResultT transformResponse(ResponseT var1, DynamoDbEnhancedClientExtension var2);

    default public ResultT execute(DynamoDbClient dynamoDbClient, DynamoDbEnhancedClientExtension extension) {
        RequestT request = this.generateRequest(extension);
        ResponseT response = this.serviceCall(dynamoDbClient).apply(request);
        return this.transformResponse(response, extension);
    }

    default public CompletableFuture<ResultT> executeAsync(DynamoDbAsyncClient dynamoDbAsyncClient, DynamoDbEnhancedClientExtension extension) {
        RequestT request = this.generateRequest(extension);
        CompletableFuture<ResponseT> response = this.asyncServiceCall(dynamoDbAsyncClient).apply(request);
        return response.thenApply(r -> this.transformResponse(r, extension));
    }
}

