/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.NestedAttributeName;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;

@SdkInternalApi
public class ProjectionExpressionConvertor {
    private static final String AMZN_MAPPED = "#AMZN_MAPPED_";
    private static final UnaryOperator<String> PROJECTION_EXPRESSION_KEY_MAPPER = k -> AMZN_MAPPED + EnhancedClientUtils.cleanAttributeName(k);
    private final List<NestedAttributeName> nestedAttributeNames;

    private ProjectionExpressionConvertor(List<NestedAttributeName> nestedAttributeNames) {
        this.nestedAttributeNames = nestedAttributeNames;
    }

    public static ProjectionExpressionConvertor create(List<NestedAttributeName> nestedAttributeNames) {
        return new ProjectionExpressionConvertor(nestedAttributeNames);
    }

    private static Optional<Map<String, String>> convertToExpressionNameMap(NestedAttributeName attributeName) {
        List<String> nestedAttributeNames = attributeName.elements();
        if (nestedAttributeNames != null) {
            LinkedHashMap resultNameMap = new LinkedHashMap();
            nestedAttributeNames.stream().forEach(nestedAttribute -> resultNameMap.put(PROJECTION_EXPRESSION_KEY_MAPPER.apply((String)nestedAttribute), nestedAttribute));
            return Optional.of(resultNameMap);
        }
        return Optional.empty();
    }

    private static Optional<String> convertToNameExpression(NestedAttributeName nestedAttributeName) {
        String name = nestedAttributeName.elements().stream().findFirst().orElse(null);
        List<String> nestedAttributes = null;
        if (nestedAttributeName.elements().size() > 1) {
            nestedAttributes = nestedAttributeName.elements().subList(1, nestedAttributeName.elements().size());
        }
        if (name != null) {
            ArrayList<String> hashSeparatedNestedStringList = new ArrayList<String>(Arrays.asList((String)PROJECTION_EXPRESSION_KEY_MAPPER.apply(name)));
            if (nestedAttributes != null) {
                nestedAttributes.stream().forEach(hashSeparatedNestedStringList::add);
            }
            return Optional.of(String.join((CharSequence)".".concat(AMZN_MAPPED), hashSeparatedNestedStringList));
        }
        return Optional.empty();
    }

    public List<NestedAttributeName> nestedAttributeNames() {
        return this.nestedAttributeNames;
    }

    public Map<String, String> convertToExpressionMap() {
        LinkedHashMap<String, String> attributeNameMap = new LinkedHashMap<String, String>();
        if (this.nestedAttributeNames() != null) {
            this.nestedAttributeNames().stream().forEach(attribs -> ProjectionExpressionConvertor.convertToExpressionNameMap(attribs).ifPresent(attributeNameMap::putAll));
        }
        return attributeNameMap;
    }

    public Optional<String> convertToProjectionExpression() {
        if (this.nestedAttributeNames != null) {
            ArrayList expressionList = new ArrayList();
            this.nestedAttributeNames().stream().filter(Objects::nonNull).filter(item -> item.elements() != null && !item.elements().isEmpty()).forEach(attributeName -> ProjectionExpressionConvertor.convertToNameExpression(attributeName).ifPresent(expressionList::add));
            String joinedExpression = String.join((CharSequence)",", expressionList.stream().distinct().collect(Collectors.toList()));
            return Optional.ofNullable(joinedExpression.isEmpty() ? null : joinedExpression);
        }
        return Optional.empty();
    }
}

