/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.AtomicBooleanAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.AtomicIntegerAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.AtomicLongAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.BigDecimalAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.BigIntegerAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.BooleanAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.ByteArrayAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.ByteAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.CharSequenceAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.CharacterArrayAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.CharacterAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.DocumentAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.DoubleAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.DurationAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnumAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.FloatAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.InstantAsStringAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.IntegerAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.ListAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.LocalDateAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.LocalDateTimeAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.LocalTimeAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.LongAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.MapAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.MonthDayAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.OffsetDateTimeAsStringAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.OptionalDoubleAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.OptionalIntAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.OptionalLongAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.PeriodAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.SdkBytesAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.SetAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.ShortAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.StringAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.StringBufferAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.StringBuilderAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.UriAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.UrlAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.UuidAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.ZoneIdAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.ZoneOffsetAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.ZonedDateTimeAsStringAttributeConverter;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
@Immutable
public final class DefaultAttributeConverterProvider
implements AttributeConverterProvider {
    private static final Logger log = Logger.loggerFor(DefaultAttributeConverterProvider.class);
    private final ConcurrentHashMap<EnhancedType<?>, AttributeConverter<?>> converterCache = new ConcurrentHashMap();

    private DefaultAttributeConverterProvider(Builder builder) {
        for (int i = builder.converters.size() - 1; i >= 0; --i) {
            AttributeConverter converter = (AttributeConverter)builder.converters.get(i);
            this.converterCache.put(converter.type(), converter);
            if (!(converter instanceof PrimitiveConverter)) continue;
            PrimitiveConverter primitiveConverter = (PrimitiveConverter)((Object)converter);
            this.converterCache.put(primitiveConverter.primitiveType(), converter);
        }
    }

    public DefaultAttributeConverterProvider() {
        this(DefaultAttributeConverterProvider.getDefaultBuilder());
    }

    public static DefaultAttributeConverterProvider create() {
        return DefaultAttributeConverterProvider.getDefaultBuilder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> AttributeConverter<T> converterFor(EnhancedType<T> type) {
        return this.findConverter(type).orElseThrow(() -> new IllegalStateException("Converter not found for " + type));
    }

    private <T> Optional<AttributeConverter<T>> findConverter(EnhancedType<T> type) {
        log.debug(() -> "Loading converter for " + type + ".");
        DocumentAttributeConverter converter = this.converterCache.get(type);
        if (converter != null) {
            return Optional.of(converter);
        }
        if (type.rawClass().isAssignableFrom(Map.class)) {
            converter = this.createMapConverter(type);
        } else if (type.rawClass().isAssignableFrom(Set.class)) {
            converter = this.createSetConverter(type);
        } else {
            if (type.rawClass().isAssignableFrom(List.class)) {
                EnhancedType<?> innerType = type.rawClassParameters().get(0);
                AttributeConverter<?> innerConverter = this.findConverter(innerType).orElseThrow(() -> new IllegalStateException("Converter not found for " + type));
                return Optional.of(ListAttributeConverter.create(innerConverter));
            }
            if (type.rawClass().isEnum()) {
                return Optional.of(EnumAttributeConverter.create(type.rawClass()));
            }
        }
        if (type.tableSchema().isPresent()) {
            converter = DocumentAttributeConverter.create(type.tableSchema().get(), type);
        }
        if (converter != null && this.shouldCache(type.rawClass())) {
            this.converterCache.put(type, converter);
        }
        return Optional.ofNullable(converter);
    }

    private boolean shouldCache(Class<?> type) {
        return !type.isAnonymousClass();
    }

    private <T> AttributeConverter<T> createMapConverter(EnhancedType<T> type) {
        EnhancedType<?> keyType = type.rawClassParameters().get(0);
        EnhancedType<?> valueType = type.rawClassParameters().get(1);
        StringConverter<?> keyConverter = StringConverterProvider.defaultProvider().converterFor(keyType);
        AttributeConverter<?> valueConverter = this.findConverter(valueType).orElseThrow(() -> new IllegalStateException("Converter not found for " + type));
        return MapAttributeConverter.mapConverter(keyConverter, valueConverter);
    }

    private <T> AttributeConverter<T> createSetConverter(EnhancedType<T> type) {
        EnhancedType<?> innerType = type.rawClassParameters().get(0);
        AttributeConverter<?> innerConverter = this.findConverter(innerType).orElseThrow(() -> new IllegalStateException("Converter not found for " + type));
        return SetAttributeConverter.setConverter(innerConverter);
    }

    private static Builder getDefaultBuilder() {
        return DefaultAttributeConverterProvider.builder().addConverter(AtomicBooleanAttributeConverter.create()).addConverter(AtomicIntegerAttributeConverter.create()).addConverter(AtomicLongAttributeConverter.create()).addConverter(BigDecimalAttributeConverter.create()).addConverter(BigIntegerAttributeConverter.create()).addConverter(BooleanAttributeConverter.create()).addConverter(ByteArrayAttributeConverter.create()).addConverter(ByteAttributeConverter.create()).addConverter(CharacterArrayAttributeConverter.create()).addConverter(CharacterAttributeConverter.create()).addConverter(CharSequenceAttributeConverter.create()).addConverter(DoubleAttributeConverter.create()).addConverter(DurationAttributeConverter.create()).addConverter(FloatAttributeConverter.create()).addConverter(InstantAsStringAttributeConverter.create()).addConverter(IntegerAttributeConverter.create()).addConverter(LocalDateAttributeConverter.create()).addConverter(LocalDateTimeAttributeConverter.create()).addConverter(LocalTimeAttributeConverter.create()).addConverter(LongAttributeConverter.create()).addConverter(MonthDayAttributeConverter.create()).addConverter(OffsetDateTimeAsStringAttributeConverter.create()).addConverter(OptionalDoubleAttributeConverter.create()).addConverter(OptionalIntAttributeConverter.create()).addConverter(OptionalLongAttributeConverter.create()).addConverter(PeriodAttributeConverter.create()).addConverter(SdkBytesAttributeConverter.create()).addConverter(ShortAttributeConverter.create()).addConverter(StringAttributeConverter.create()).addConverter(StringBufferAttributeConverter.create()).addConverter(StringBuilderAttributeConverter.create()).addConverter(UriAttributeConverter.create()).addConverter(UrlAttributeConverter.create()).addConverter(UuidAttributeConverter.create()).addConverter(ZonedDateTimeAsStringAttributeConverter.create()).addConverter(ZoneIdAttributeConverter.create()).addConverter(ZoneOffsetAttributeConverter.create());
    }

    public static class Builder {
        private List<AttributeConverter<?>> converters = new ArrayList();

        private Builder() {
        }

        public Builder addConverter(AttributeConverter<?> converter) {
            Validate.paramNotNull(converter, (String)"converter");
            this.converters.add(converter);
            return this;
        }

        public DefaultAttributeConverterProvider build() {
            return new DefaultAttributeConverterProvider(this);
        }
    }
}

