/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.BeanAttributeGetter;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.BeanAttributeSetter;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.ObjectConstructor;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.WrappedTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.BeanTableSchemaAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbBean;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbConvertedBy;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbFlatten;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbIgnore;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbImmutable;

@SdkPublicApi
public final class BeanTableSchema<T>
extends WrappedTableSchema<T, StaticTableSchema<T>> {
    private static final String ATTRIBUTE_TAG_STATIC_SUPPLIER_NAME = "attributeTagFor";

    private BeanTableSchema(StaticTableSchema<T> staticTableSchema) {
        super(staticTableSchema);
    }

    public static <T> BeanTableSchema<T> create(Class<T> beanClass) {
        return new BeanTableSchema<T>(BeanTableSchema.createStaticTableSchema(beanClass));
    }

    private static <T> StaticTableSchema<T> createStaticTableSchema(Class<T> beanClass) {
        BeanInfo beanInfo;
        DynamoDbBean dynamoDbBean = beanClass.getAnnotation(DynamoDbBean.class);
        if (dynamoDbBean == null) {
            throw new IllegalArgumentException("A DynamoDb bean class must be annotated with @DynamoDbBean");
        }
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
        Supplier<T> newObjectSupplier = BeanTableSchema.newObjectSupplierForClass(beanClass);
        StaticTableSchema.Builder builder = StaticTableSchema.builder(beanClass).newItemSupplier(newObjectSupplier);
        builder.attributeConverterProviders(BeanTableSchema.createConverterProvidersFromAnnotation(dynamoDbBean));
        ArrayList attributes = new ArrayList();
        Arrays.stream(beanInfo.getPropertyDescriptors()).filter(BeanTableSchema::isMappableProperty).forEach(propertyDescriptor -> {
            DynamoDbFlatten dynamoDbFlatten = BeanTableSchema.getPropertyAnnotation(propertyDescriptor, DynamoDbFlatten.class);
            if (dynamoDbFlatten != null) {
                builder.flatten(TableSchema.fromClass(propertyDescriptor.getReadMethod().getReturnType()), BeanTableSchema.getterForProperty(propertyDescriptor, beanClass), BeanTableSchema.setterForProperty(propertyDescriptor, beanClass));
            } else {
                StaticAttribute.Builder attributeBuilder = BeanTableSchema.staticAttributeBuilder(propertyDescriptor, beanClass);
                Optional<AttributeConverter> attributeConverter = BeanTableSchema.createAttributeConverterFromAnnotation(propertyDescriptor);
                attributeConverter.ifPresent(attributeBuilder::attributeConverter);
                BeanTableSchema.addTagsToAttribute(attributeBuilder, propertyDescriptor);
                attributes.add(attributeBuilder.build());
            }
        });
        builder.attributes(attributes);
        return builder.build();
    }

    private static List<AttributeConverterProvider> createConverterProvidersFromAnnotation(DynamoDbBean dynamoDbBean) {
        Class<? extends AttributeConverterProvider>[] providerClasses = dynamoDbBean.converterProviders();
        return Arrays.stream(providerClasses).map(c -> (AttributeConverterProvider)BeanTableSchema.newObjectSupplierForClass(c).get()).collect(Collectors.toList());
    }

    private static <T> StaticAttribute.Builder<T, ?> staticAttributeBuilder(PropertyDescriptor propertyDescriptor, Class<T> beanClass) {
        Type propertyType = propertyDescriptor.getReadMethod().getGenericReturnType();
        EnhancedType<?> propertyTypeToken = BeanTableSchema.convertTypeToEnhancedType(propertyType);
        return StaticAttribute.builder(beanClass, propertyTypeToken).name(BeanTableSchema.attributeNameForProperty(propertyDescriptor)).getter(BeanTableSchema.getterForProperty(propertyDescriptor, beanClass)).setter(BeanTableSchema.setterForProperty(propertyDescriptor, beanClass));
    }

    private static EnhancedType<?> convertTypeToEnhancedType(Type type) {
        Class clazz = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (List.class.equals((Object)rawType)) {
                return EnhancedType.listOf(BeanTableSchema.convertTypeToEnhancedType(parameterizedType.getActualTypeArguments()[0]));
            }
            if (Map.class.equals((Object)rawType)) {
                return EnhancedType.mapOf(EnhancedType.of(parameterizedType.getActualTypeArguments()[0]), BeanTableSchema.convertTypeToEnhancedType(parameterizedType.getActualTypeArguments()[1]));
            }
            if (rawType instanceof Class) {
                clazz = (Class)rawType;
            }
        } else if (type instanceof Class) {
            clazz = (Class)type;
        }
        if (clazz != null && (clazz.getAnnotation(DynamoDbImmutable.class) != null || clazz.getAnnotation(DynamoDbBean.class) != null)) {
            return EnhancedType.documentOf(clazz, TableSchema.fromClass(clazz));
        }
        return EnhancedType.of(type);
    }

    private static Optional<AttributeConverter> createAttributeConverterFromAnnotation(PropertyDescriptor propertyDescriptor) {
        DynamoDbConvertedBy attributeConverterBean = BeanTableSchema.getPropertyAnnotation(propertyDescriptor, DynamoDbConvertedBy.class);
        Optional<Class> optionalClass = Optional.ofNullable(attributeConverterBean).map(DynamoDbConvertedBy::value);
        return optionalClass.map(clazz -> (AttributeConverter)BeanTableSchema.newObjectSupplierForClass(clazz).get());
    }

    private static void addTagsToAttribute(StaticAttribute.Builder<?, ?> attributeBuilder, PropertyDescriptor propertyDescriptor) {
        BeanTableSchema.propertyAnnotations(propertyDescriptor).forEach(annotation -> {
            BeanTableSchemaAttributeTag beanTableSchemaAttributeTag = annotation.annotationType().getAnnotation(BeanTableSchemaAttributeTag.class);
            if (beanTableSchemaAttributeTag != null) {
                StaticAttributeTag staticAttributeTag;
                Method tagMethod;
                Class<?> tagClass = beanTableSchemaAttributeTag.value();
                try {
                    tagMethod = tagClass.getDeclaredMethod(ATTRIBUTE_TAG_STATIC_SUPPLIER_NAME, annotation.annotationType());
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(String.format("Could not find a static method named '%s' on class '%s' that returns an AttributeTag for annotation '%s'", ATTRIBUTE_TAG_STATIC_SUPPLIER_NAME, tagClass, annotation.annotationType()), e);
                }
                if (!Modifier.isStatic(tagMethod.getModifiers())) {
                    throw new RuntimeException(String.format("Could not find a static method named '%s' on class '%s' that returns an AttributeTag for annotation '%s'", ATTRIBUTE_TAG_STATIC_SUPPLIER_NAME, tagClass, annotation.annotationType()));
                }
                try {
                    staticAttributeTag = (StaticAttributeTag)tagMethod.invoke(null, annotation);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(String.format("Could not invoke method to create AttributeTag for annotation '%s' on class '%s'.", annotation.annotationType(), tagClass), e);
                }
                attributeBuilder.addTag(staticAttributeTag);
            }
        });
    }

    private static <R> Supplier<R> newObjectSupplierForClass(Class<R> clazz) {
        try {
            return ObjectConstructor.create(clazz, clazz.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Class '%s' appears to have no default constructor thus cannot be used with the BeanTableSchema", clazz), e);
        }
    }

    private static <T, R> Function<T, R> getterForProperty(PropertyDescriptor propertyDescriptor, Class<T> beanClass) {
        Method readMethod = propertyDescriptor.getReadMethod();
        return BeanAttributeGetter.create(beanClass, readMethod);
    }

    private static <T, R> BiConsumer<T, R> setterForProperty(PropertyDescriptor propertyDescriptor, Class<T> beanClass) {
        Method writeMethod = propertyDescriptor.getWriteMethod();
        return BeanAttributeSetter.create(beanClass, writeMethod);
    }

    private static String attributeNameForProperty(PropertyDescriptor propertyDescriptor) {
        DynamoDbAttribute dynamoDbAttribute = BeanTableSchema.getPropertyAnnotation(propertyDescriptor, DynamoDbAttribute.class);
        if (dynamoDbAttribute != null) {
            return dynamoDbAttribute.value();
        }
        return propertyDescriptor.getName();
    }

    private static boolean isMappableProperty(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getReadMethod() != null && propertyDescriptor.getWriteMethod() != null && BeanTableSchema.getPropertyAnnotation(propertyDescriptor, DynamoDbIgnore.class) == null;
    }

    private static <R extends Annotation> R getPropertyAnnotation(PropertyDescriptor propertyDescriptor, Class<R> annotationType) {
        R getterAnnotation = propertyDescriptor.getReadMethod().getAnnotation(annotationType);
        R setterAnnotation = propertyDescriptor.getWriteMethod().getAnnotation(annotationType);
        if (getterAnnotation != null) {
            return getterAnnotation;
        }
        return setterAnnotation;
    }

    private static List<? extends Annotation> propertyAnnotations(PropertyDescriptor propertyDescriptor) {
        return Stream.concat(Arrays.stream(propertyDescriptor.getReadMethod().getAnnotations()), Arrays.stream(propertyDescriptor.getWriteMethod().getAnnotations())).collect(Collectors.toList());
    }
}

