/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.BooleanStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class BooleanAttributeConverter
implements AttributeConverter<Boolean>,
PrimitiveConverter<Boolean> {
    private static final Visitor VISITOR = new Visitor();
    private static final BooleanStringConverter STRING_CONVERTER = BooleanStringConverter.create();

    private BooleanAttributeConverter() {
    }

    public static BooleanAttributeConverter create() {
        return new BooleanAttributeConverter();
    }

    @Override
    public EnhancedType<Boolean> type() {
        return EnhancedType.of(Boolean.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.BOOL;
    }

    @Override
    public AttributeValue transformFrom(Boolean input) {
        return (AttributeValue)AttributeValue.builder().bool(input).build();
    }

    @Override
    public Boolean transformTo(AttributeValue input) {
        if (input.bool() != null) {
            return EnhancedAttributeValue.fromBoolean(input.bool()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    @Override
    public EnhancedType<Boolean> primitiveType() {
        return EnhancedType.of(Boolean.TYPE);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<Boolean> {
        private Visitor() {
            super(Boolean.class, BooleanAttributeConverter.class);
        }

        @Override
        public Boolean convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public Boolean convertBoolean(Boolean value) {
            return value;
        }
    }
}

