/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.PaginatedOperation;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkInternalApi
public interface PaginatedTableOperation<ItemT, RequestT, ResponseT, ResultT>
extends PaginatedOperation<ItemT, RequestT, ResponseT, ResultT> {
    default public SdkIterable<ResultT> executeOnPrimaryIndex(TableSchema<ItemT> tableSchema, String tableName, DynamoDbEnhancedClientExtension extension, DynamoDbClient dynamoDbClient) {
        OperationContext context = OperationContext.create(tableName, TableMetadata.primaryIndexName());
        return this.execute(tableSchema, context, extension, dynamoDbClient);
    }

    default public SdkPublisher<ResultT> executeOnPrimaryIndexAsync(TableSchema<ItemT> tableSchema, String tableName, DynamoDbEnhancedClientExtension extension, DynamoDbAsyncClient dynamoDbAsyncClient) {
        OperationContext context = OperationContext.create(tableName, TableMetadata.primaryIndexName());
        return this.executeAsync(tableSchema, context, extension, dynamoDbAsyncClient);
    }
}

