/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeType;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public final class StaticAttributeType<T>
implements AttributeType<T> {
    private final Function<T, AttributeValue> objectTransformer;
    private final Function<AttributeValue, T> attributeValueTransformer;
    private final AttributeValueType attributeValueType;

    private StaticAttributeType(Function<T, AttributeValue> objectTransformer, Function<AttributeValue, T> attributeValueTransformer, AttributeValueType attributeValueType) {
        this.objectTransformer = objectTransformer;
        this.attributeValueTransformer = attributeValueTransformer;
        this.attributeValueType = attributeValueType;
    }

    public static <T> StaticAttributeType<T> create(Function<T, AttributeValue> objectTransformer, Function<AttributeValue, T> attributeValueTransformer, AttributeValueType attributeValueType) {
        return new StaticAttributeType<T>(objectTransformer, attributeValueTransformer, attributeValueType);
    }

    @Override
    public AttributeValue objectToAttributeValue(T object) {
        return this.objectTransformer.apply(object);
    }

    @Override
    public T attributeValueToObject(AttributeValue attributeValue) {
        return this.attributeValueTransformer.apply(attributeValue);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return this.attributeValueType;
    }
}

