/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.core;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Key;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.DynamoDbMappedIndex;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkPublicApi
@ThreadSafe
public class DynamoDbMappedTable<T>
implements MappedTable<T> {
    private final DynamoDbClient dynamoDbClient;
    private final MapperExtension mapperExtension;
    private final TableSchema<T> tableSchema;
    private final String tableName;

    DynamoDbMappedTable(DynamoDbClient dynamoDbClient, MapperExtension mapperExtension, TableSchema<T> tableSchema, String tableName) {
        this.dynamoDbClient = dynamoDbClient;
        this.mapperExtension = mapperExtension;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
    }

    @Override
    public <R> R execute(TableOperation<T, ?, ?, R> operationToPerform) {
        return operationToPerform.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public MapperExtension getMapperExtension() {
        return this.mapperExtension;
    }

    @Override
    public TableSchema<T> getTableSchema() {
        return this.tableSchema;
    }

    public DynamoDbClient getDynamoDbClient() {
        return this.dynamoDbClient;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public DynamoDbMappedIndex<T> index(String indexName) {
        this.tableSchema.getTableMetadata().getIndexPartitionKey(indexName);
        return new DynamoDbMappedIndex<T>(this.dynamoDbClient, this.mapperExtension, this.tableSchema, this.tableName, indexName);
    }

    @Override
    public Key keyFrom(T item) {
        return Utils.createKeyFromItem(item, this.tableSchema, TableMetadata.getPrimaryIndexName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamoDbMappedTable that = (DynamoDbMappedTable)o;
        if (this.dynamoDbClient != null ? !this.dynamoDbClient.equals(that.dynamoDbClient) : that.dynamoDbClient != null) {
            return false;
        }
        if (this.mapperExtension != null ? !this.mapperExtension.equals(that.mapperExtension) : that.mapperExtension != null) {
            return false;
        }
        if (this.tableSchema != null ? !this.tableSchema.equals(that.tableSchema) : that.tableSchema != null) {
            return false;
        }
        return this.tableName != null ? this.tableName.equals(that.tableName) : that.tableName == null;
    }

    public int hashCode() {
        int result = this.dynamoDbClient != null ? this.dynamoDbClient.hashCode() : 0;
        result = 31 * result + (this.mapperExtension != null ? this.mapperExtension.hashCode() : 0);
        result = 31 * result + (this.tableSchema != null ? this.tableSchema.hashCode() : 0);
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        return result;
    }
}

