/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dsql.model.DsqlRequest;
import software.amazon.awssdk.services.dsql.model.MultiRegionProperties;
import software.amazon.awssdk.services.dsql.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterRequest
extends DsqlRequest
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deletionProtectionEnabled").getter(CreateClusterRequest.getter(CreateClusterRequest::deletionProtectionEnabled)).setter(CreateClusterRequest.setter(Builder::deletionProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtectionEnabled").build()}).build();
    private static final SdkField<String> KMS_ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsEncryptionKey").getter(CreateClusterRequest.getter(CreateClusterRequest::kmsEncryptionKey)).setter(CreateClusterRequest.setter(Builder::kmsEncryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsEncryptionKey").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateClusterRequest.getter(CreateClusterRequest::tags)).setter(CreateClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateClusterRequest.getter(CreateClusterRequest::clientToken)).setter(CreateClusterRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<MultiRegionProperties> MULTI_REGION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("multiRegionProperties").getter(CreateClusterRequest.getter(CreateClusterRequest::multiRegionProperties)).setter(CreateClusterRequest.setter(Builder::multiRegionProperties)).constructor(MultiRegionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiRegionProperties").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policy").getter(CreateClusterRequest.getter(CreateClusterRequest::policy)).setter(CreateClusterRequest.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final SdkField<Boolean> BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("bypassPolicyLockoutSafetyCheck").getter(CreateClusterRequest.getter(CreateClusterRequest::bypassPolicyLockoutSafetyCheck)).setter(CreateClusterRequest.setter(Builder::bypassPolicyLockoutSafetyCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bypassPolicyLockoutSafetyCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETION_PROTECTION_ENABLED_FIELD, KMS_ENCRYPTION_KEY_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD, MULTI_REGION_PROPERTIES_FIELD, POLICY_FIELD, BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateClusterRequest.memberNameToFieldInitializer();
    private final Boolean deletionProtectionEnabled;
    private final String kmsEncryptionKey;
    private final Map<String, String> tags;
    private final String clientToken;
    private final MultiRegionProperties multiRegionProperties;
    private final String policy;
    private final Boolean bypassPolicyLockoutSafetyCheck;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.kmsEncryptionKey = builder.kmsEncryptionKey;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.multiRegionProperties = builder.multiRegionProperties;
        this.policy = builder.policy;
        this.bypassPolicyLockoutSafetyCheck = builder.bypassPolicyLockoutSafetyCheck;
    }

    public final Boolean deletionProtectionEnabled() {
        return this.deletionProtectionEnabled;
    }

    public final String kmsEncryptionKey() {
        return this.kmsEncryptionKey;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final MultiRegionProperties multiRegionProperties() {
        return this.multiRegionProperties;
    }

    public final String policy() {
        return this.policy;
    }

    public final Boolean bypassPolicyLockoutSafetyCheck() {
        return this.bypassPolicyLockoutSafetyCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.bypassPolicyLockoutSafetyCheck());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        return Objects.equals(this.deletionProtectionEnabled(), other.deletionProtectionEnabled()) && Objects.equals(this.kmsEncryptionKey(), other.kmsEncryptionKey()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.multiRegionProperties(), other.multiRegionProperties()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.bypassPolicyLockoutSafetyCheck(), other.bypassPolicyLockoutSafetyCheck());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClusterRequest").add("DeletionProtectionEnabled", (Object)this.deletionProtectionEnabled()).add("KmsEncryptionKey", (Object)this.kmsEncryptionKey()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).add("MultiRegionProperties", (Object)this.multiRegionProperties()).add("Policy", (Object)this.policy()).add("BypassPolicyLockoutSafetyCheck", (Object)this.bypassPolicyLockoutSafetyCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deletionProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.deletionProtectionEnabled()));
            }
            case "kmsEncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.kmsEncryptionKey()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "multiRegionProperties": {
                return Optional.ofNullable(clazz.cast(this.multiRegionProperties()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "bypassPolicyLockoutSafetyCheck": {
                return Optional.ofNullable(clazz.cast(this.bypassPolicyLockoutSafetyCheck()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        map.put("kmsEncryptionKey", KMS_ENCRYPTION_KEY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("multiRegionProperties", MULTI_REGION_PROPERTIES_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("bypassPolicyLockoutSafetyCheck", BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DsqlRequest.BuilderImpl
    implements Builder {
        private Boolean deletionProtectionEnabled;
        private String kmsEncryptionKey;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;
        private MultiRegionProperties multiRegionProperties;
        private String policy;
        private Boolean bypassPolicyLockoutSafetyCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            this.deletionProtectionEnabled(model.deletionProtectionEnabled);
            this.kmsEncryptionKey(model.kmsEncryptionKey);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
            this.multiRegionProperties(model.multiRegionProperties);
            this.policy(model.policy);
            this.bypassPolicyLockoutSafetyCheck(model.bypassPolicyLockoutSafetyCheck);
        }

        public final Boolean getDeletionProtectionEnabled() {
            return this.deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final String getKmsEncryptionKey() {
            return this.kmsEncryptionKey;
        }

        public final void setKmsEncryptionKey(String kmsEncryptionKey) {
            this.kmsEncryptionKey = kmsEncryptionKey;
        }

        @Override
        public final Builder kmsEncryptionKey(String kmsEncryptionKey) {
            this.kmsEncryptionKey = kmsEncryptionKey;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final MultiRegionProperties.Builder getMultiRegionProperties() {
            return this.multiRegionProperties != null ? this.multiRegionProperties.toBuilder() : null;
        }

        public final void setMultiRegionProperties(MultiRegionProperties.BuilderImpl multiRegionProperties) {
            this.multiRegionProperties = multiRegionProperties != null ? multiRegionProperties.build() : null;
        }

        @Override
        public final Builder multiRegionProperties(MultiRegionProperties multiRegionProperties) {
            this.multiRegionProperties = multiRegionProperties;
            return this;
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final Boolean getBypassPolicyLockoutSafetyCheck() {
            return this.bypassPolicyLockoutSafetyCheck;
        }

        public final void setBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public final Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DsqlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder deletionProtectionEnabled(Boolean var1);

        public Builder kmsEncryptionKey(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder multiRegionProperties(MultiRegionProperties var1);

        default public Builder multiRegionProperties(Consumer<MultiRegionProperties.Builder> multiRegionProperties) {
            return this.multiRegionProperties((MultiRegionProperties)((MultiRegionProperties.Builder)MultiRegionProperties.builder().applyMutation(multiRegionProperties)).build());
        }

        public Builder policy(String var1);

        public Builder bypassPolicyLockoutSafetyCheck(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

