/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.dsql.DefaultDsqlClientBuilder;
import software.amazon.awssdk.services.dsql.DsqlClientBuilder;
import software.amazon.awssdk.services.dsql.DsqlServiceClientConfiguration;
import software.amazon.awssdk.services.dsql.DsqlUtilities;
import software.amazon.awssdk.services.dsql.model.AccessDeniedException;
import software.amazon.awssdk.services.dsql.model.ConflictException;
import software.amazon.awssdk.services.dsql.model.CreateClusterRequest;
import software.amazon.awssdk.services.dsql.model.CreateClusterResponse;
import software.amazon.awssdk.services.dsql.model.CreateMultiRegionClustersRequest;
import software.amazon.awssdk.services.dsql.model.CreateMultiRegionClustersResponse;
import software.amazon.awssdk.services.dsql.model.DeleteClusterRequest;
import software.amazon.awssdk.services.dsql.model.DeleteClusterResponse;
import software.amazon.awssdk.services.dsql.model.DeleteMultiRegionClustersRequest;
import software.amazon.awssdk.services.dsql.model.DeleteMultiRegionClustersResponse;
import software.amazon.awssdk.services.dsql.model.DsqlException;
import software.amazon.awssdk.services.dsql.model.GetClusterRequest;
import software.amazon.awssdk.services.dsql.model.GetClusterResponse;
import software.amazon.awssdk.services.dsql.model.GetVpcEndpointServiceNameRequest;
import software.amazon.awssdk.services.dsql.model.GetVpcEndpointServiceNameResponse;
import software.amazon.awssdk.services.dsql.model.InternalServerException;
import software.amazon.awssdk.services.dsql.model.ListClustersRequest;
import software.amazon.awssdk.services.dsql.model.ListClustersResponse;
import software.amazon.awssdk.services.dsql.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.dsql.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.dsql.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dsql.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.dsql.model.TagResourceRequest;
import software.amazon.awssdk.services.dsql.model.TagResourceResponse;
import software.amazon.awssdk.services.dsql.model.ThrottlingException;
import software.amazon.awssdk.services.dsql.model.UntagResourceRequest;
import software.amazon.awssdk.services.dsql.model.UntagResourceResponse;
import software.amazon.awssdk.services.dsql.model.UpdateClusterRequest;
import software.amazon.awssdk.services.dsql.model.UpdateClusterResponse;
import software.amazon.awssdk.services.dsql.model.ValidationException;
import software.amazon.awssdk.services.dsql.paginators.ListClustersIterable;
import software.amazon.awssdk.services.dsql.waiters.DsqlWaiter;

@SdkPublicApi
@ThreadSafe
public interface DsqlClient
extends AwsClient {
    public static final String SERVICE_NAME = "dsql";
    public static final String SERVICE_METADATA_ID = "dsql";

    default public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, DsqlException {
        throw new UnsupportedOperationException();
    }

    default public CreateClusterResponse createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, DsqlException {
        return this.createCluster((CreateClusterRequest)((Object)((CreateClusterRequest.Builder)CreateClusterRequest.builder().applyMutation(createClusterRequest)).build()));
    }

    @Deprecated
    default public CreateMultiRegionClustersResponse createMultiRegionClusters(CreateMultiRegionClustersRequest createMultiRegionClustersRequest) throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, DsqlException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public CreateMultiRegionClustersResponse createMultiRegionClusters(Consumer<CreateMultiRegionClustersRequest.Builder> createMultiRegionClustersRequest) throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, DsqlException {
        return this.createMultiRegionClusters((CreateMultiRegionClustersRequest)((Object)((CreateMultiRegionClustersRequest.Builder)CreateMultiRegionClustersRequest.builder().applyMutation(createMultiRegionClustersRequest)).build()));
    }

    default public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, DsqlException {
        throw new UnsupportedOperationException();
    }

    default public DeleteClusterResponse deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, DsqlException {
        return this.deleteCluster((DeleteClusterRequest)((Object)((DeleteClusterRequest.Builder)DeleteClusterRequest.builder().applyMutation(deleteClusterRequest)).build()));
    }

    @Deprecated
    default public DeleteMultiRegionClustersResponse deleteMultiRegionClusters(DeleteMultiRegionClustersRequest deleteMultiRegionClustersRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, DsqlException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public DeleteMultiRegionClustersResponse deleteMultiRegionClusters(Consumer<DeleteMultiRegionClustersRequest.Builder> deleteMultiRegionClustersRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, DsqlException {
        return this.deleteMultiRegionClusters((DeleteMultiRegionClustersRequest)((Object)((DeleteMultiRegionClustersRequest.Builder)DeleteMultiRegionClustersRequest.builder().applyMutation(deleteMultiRegionClustersRequest)).build()));
    }

    default public GetClusterResponse getCluster(GetClusterRequest getClusterRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        throw new UnsupportedOperationException();
    }

    default public GetClusterResponse getCluster(Consumer<GetClusterRequest.Builder> getClusterRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        return this.getCluster((GetClusterRequest)((Object)((GetClusterRequest.Builder)GetClusterRequest.builder().applyMutation(getClusterRequest)).build()));
    }

    default public GetVpcEndpointServiceNameResponse getVpcEndpointServiceName(GetVpcEndpointServiceNameRequest getVpcEndpointServiceNameRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        throw new UnsupportedOperationException();
    }

    default public GetVpcEndpointServiceNameResponse getVpcEndpointServiceName(Consumer<GetVpcEndpointServiceNameRequest.Builder> getVpcEndpointServiceNameRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        return this.getVpcEndpointServiceName((GetVpcEndpointServiceNameRequest)((Object)((GetVpcEndpointServiceNameRequest.Builder)GetVpcEndpointServiceNameRequest.builder().applyMutation(getVpcEndpointServiceNameRequest)).build()));
    }

    default public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        throw new UnsupportedOperationException();
    }

    default public ListClustersResponse listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        return this.listClusters((ListClustersRequest)((Object)((ListClustersRequest.Builder)ListClustersRequest.builder().applyMutation(listClustersRequest)).build()));
    }

    default public ListClustersIterable listClustersPaginator(ListClustersRequest listClustersRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        return new ListClustersIterable(this, listClustersRequest);
    }

    default public ListClustersIterable listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        return this.listClustersPaginator((ListClustersRequest)((Object)((ListClustersRequest.Builder)ListClustersRequest.builder().applyMutation(listClustersRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DsqlException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, DsqlException {
        throw new UnsupportedOperationException();
    }

    default public UpdateClusterResponse updateCluster(Consumer<UpdateClusterRequest.Builder> updateClusterRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, DsqlException {
        return this.updateCluster((UpdateClusterRequest)((Object)((UpdateClusterRequest.Builder)UpdateClusterRequest.builder().applyMutation(updateClusterRequest)).build()));
    }

    default public DsqlUtilities utilities() {
        throw new UnsupportedOperationException();
    }

    default public DsqlWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    public static DsqlClient create() {
        return (DsqlClient)DsqlClient.builder().build();
    }

    public static DsqlClientBuilder builder() {
        return new DefaultDsqlClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"dsql");
    }

    default public DsqlServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

