/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.model;

import java.time.Duration;
import java.util.Objects;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class GenerateAuthTokenRequest
implements ToCopyableBuilder<Builder, GenerateAuthTokenRequest> {
    private static final Duration EXPIRATION_DURATION = Duration.ofSeconds(900L);
    private final String hostname;
    private final Region region;
    private final Duration expiresIn;
    private final IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider;

    private GenerateAuthTokenRequest(BuilderImpl builder) {
        this.hostname = (String)Validate.notEmpty((CharSequence)builder.hostname, (String)"hostname", (Object[])new Object[0]);
        this.region = builder.region;
        this.credentialsProvider = builder.credentialsProvider;
        this.expiresIn = builder.expiresIn != null ? builder.expiresIn : EXPIRATION_DURATION;
    }

    public String toString() {
        return ToString.builder((String)"GenerateAuthTokenRequest").add("hostname", (Object)this.hostname).add("region", (Object)this.region).add("expiresIn", (Object)this.expiresIn).add("credentialsProvider", this.credentialsProvider).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerateAuthTokenRequest that = (GenerateAuthTokenRequest)o;
        return Objects.equals(this.hostname, that.hostname) && Objects.equals(this.region, that.region) && Objects.equals(this.expiresIn, that.expiresIn) && Objects.equals(this.credentialsProvider, that.credentialsProvider);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname);
        hashCode = 31 * hashCode + Objects.hashCode(this.region);
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresIn);
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsProvider);
        return hashCode;
    }

    public String hostname() {
        return this.hostname;
    }

    public Duration expiresIn() {
        return this.expiresIn;
    }

    public Region region() {
        return this.region;
    }

    public AwsCredentialsProvider credentialsProvider() {
        return CredentialUtils.toCredentialsProvider(this.credentialsProvider);
    }

    public IdentityProvider<? extends AwsCredentialsIdentity> credentialsIdentityProvider() {
        return this.credentialsProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static final class BuilderImpl
    implements Builder {
        private String hostname;
        private Region region;
        private Duration expiresIn;
        private IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateAuthTokenRequest request) {
            this.hostname = request.hostname;
            this.region = request.region;
            this.expiresIn = request.expiresIn;
            this.credentialsProvider = request.credentialsProvider;
        }

        @Override
        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Override
        public Builder expiresIn(Duration expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public GenerateAuthTokenRequest build() {
            return new GenerateAuthTokenRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends CopyableBuilder<Builder, GenerateAuthTokenRequest> {
        public Builder hostname(String var1);

        public Builder region(Region var1);

        public Builder expiresIn(Duration var1);

        default public Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            return this.credentialsProvider((IdentityProvider<? extends AwsCredentialsIdentity>)credentialsProvider);
        }

        default public Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
            throw new UnsupportedOperationException();
        }

        public GenerateAuthTokenRequest build();
    }
}

