/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dsql.model.ClusterListCopier;
import software.amazon.awssdk.services.dsql.model.ClusterSummary;
import software.amazon.awssdk.services.dsql.model.DsqlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClustersResponse
extends DsqlResponse
implements ToCopyableBuilder<Builder, ListClustersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListClustersResponse.getter(ListClustersResponse::nextToken)).setter(ListClustersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ClusterSummary>> CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clusters").getter(ListClustersResponse.getter(ListClustersResponse::clusters)).setter(ListClustersResponse.setter(Builder::clusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CLUSTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListClustersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ClusterSummary> clusters;

    private ListClustersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.clusters = builder.clusters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasClusters() {
        return this.clusters != null && !(this.clusters instanceof SdkAutoConstructList);
    }

    public final List<ClusterSummary> clusters() {
        return this.clusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusters() ? this.clusters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasClusters() == other.hasClusters() && Objects.equals(this.clusters(), other.clusters());
    }

    public final String toString() {
        return ToString.builder((String)"ListClustersResponse").add("NextToken", (Object)this.nextToken()).add("Clusters", this.hasClusters() ? this.clusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "clusters": {
                return Optional.ofNullable(clazz.cast(this.clusters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("clusters", CLUSTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClustersResponse, T> g) {
        return obj -> g.apply((ListClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DsqlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ClusterSummary> clusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.clusters(model.clusters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ClusterSummary.Builder> getClusters() {
            List<ClusterSummary.Builder> result = ClusterListCopier.copyToBuilder(this.clusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusters(Collection<ClusterSummary.BuilderImpl> clusters) {
            this.clusters = ClusterListCopier.copyFromBuilder(clusters);
        }

        @Override
        public final Builder clusters(Collection<ClusterSummary> clusters) {
            this.clusters = ClusterListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(ClusterSummary ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Consumer<ClusterSummary.Builder> ... clusters) {
            this.clusters(Stream.of(clusters).map(c -> (ClusterSummary)((ClusterSummary.Builder)ClusterSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DsqlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClustersResponse> {
        public Builder nextToken(String var1);

        public Builder clusters(Collection<ClusterSummary> var1);

        public Builder clusters(ClusterSummary ... var1);

        public Builder clusters(Consumer<ClusterSummary.Builder> ... var1);
    }
}

