/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.drs.model.LaunchDisposition;
import software.amazon.awssdk.services.drs.model.Licensing;
import software.amazon.awssdk.services.drs.model.TagsMapCopier;
import software.amazon.awssdk.services.drs.model.TargetInstanceTypeRightSizingMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchConfigurationTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchConfigurationTemplate> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::arn)).setter(LaunchConfigurationTemplate.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Boolean> COPY_PRIVATE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("copyPrivateIp").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::copyPrivateIp)).setter(LaunchConfigurationTemplate.setter(Builder::copyPrivateIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyPrivateIp").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("copyTags").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::copyTags)).setter(LaunchConfigurationTemplate.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTags").build()}).build();
    private static final SdkField<String> EXPORT_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportBucketArn").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::exportBucketArn)).setter(LaunchConfigurationTemplate.setter(Builder::exportBucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportBucketArn").build()}).build();
    private static final SdkField<String> LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchConfigurationTemplateID").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::launchConfigurationTemplateID)).setter(LaunchConfigurationTemplate.setter(Builder::launchConfigurationTemplateID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfigurationTemplateID").build()}).build();
    private static final SdkField<String> LAUNCH_DISPOSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchDisposition").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::launchDispositionAsString)).setter(LaunchConfigurationTemplate.setter(Builder::launchDisposition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDisposition").build()}).build();
    private static final SdkField<Boolean> LAUNCH_INTO_SOURCE_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("launchIntoSourceInstance").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::launchIntoSourceInstance)).setter(LaunchConfigurationTemplate.setter(Builder::launchIntoSourceInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchIntoSourceInstance").build()}).build();
    private static final SdkField<Licensing> LICENSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("licensing").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::licensing)).setter(LaunchConfigurationTemplate.setter(Builder::licensing)).constructor(Licensing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licensing").build()}).build();
    private static final SdkField<Boolean> POST_LAUNCH_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("postLaunchEnabled").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::postLaunchEnabled)).setter(LaunchConfigurationTemplate.setter(Builder::postLaunchEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postLaunchEnabled").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::tags)).setter(LaunchConfigurationTemplate.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetInstanceTypeRightSizingMethod").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::targetInstanceTypeRightSizingMethodAsString)).setter(LaunchConfigurationTemplate.setter(Builder::targetInstanceTypeRightSizingMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstanceTypeRightSizingMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COPY_PRIVATE_IP_FIELD, COPY_TAGS_FIELD, EXPORT_BUCKET_ARN_FIELD, LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD, LAUNCH_DISPOSITION_FIELD, LAUNCH_INTO_SOURCE_INSTANCE_FIELD, LICENSING_FIELD, POST_LAUNCH_ENABLED_FIELD, TAGS_FIELD, TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchConfigurationTemplate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Boolean copyPrivateIp;
    private final Boolean copyTags;
    private final String exportBucketArn;
    private final String launchConfigurationTemplateID;
    private final String launchDisposition;
    private final Boolean launchIntoSourceInstance;
    private final Licensing licensing;
    private final Boolean postLaunchEnabled;
    private final Map<String, String> tags;
    private final String targetInstanceTypeRightSizingMethod;

    private LaunchConfigurationTemplate(BuilderImpl builder) {
        this.arn = builder.arn;
        this.copyPrivateIp = builder.copyPrivateIp;
        this.copyTags = builder.copyTags;
        this.exportBucketArn = builder.exportBucketArn;
        this.launchConfigurationTemplateID = builder.launchConfigurationTemplateID;
        this.launchDisposition = builder.launchDisposition;
        this.launchIntoSourceInstance = builder.launchIntoSourceInstance;
        this.licensing = builder.licensing;
        this.postLaunchEnabled = builder.postLaunchEnabled;
        this.tags = builder.tags;
        this.targetInstanceTypeRightSizingMethod = builder.targetInstanceTypeRightSizingMethod;
    }

    public final String arn() {
        return this.arn;
    }

    public final Boolean copyPrivateIp() {
        return this.copyPrivateIp;
    }

    public final Boolean copyTags() {
        return this.copyTags;
    }

    public final String exportBucketArn() {
        return this.exportBucketArn;
    }

    public final String launchConfigurationTemplateID() {
        return this.launchConfigurationTemplateID;
    }

    public final LaunchDisposition launchDisposition() {
        return LaunchDisposition.fromValue(this.launchDisposition);
    }

    public final String launchDispositionAsString() {
        return this.launchDisposition;
    }

    public final Boolean launchIntoSourceInstance() {
        return this.launchIntoSourceInstance;
    }

    public final Licensing licensing() {
        return this.licensing;
    }

    public final Boolean postLaunchEnabled() {
        return this.postLaunchEnabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod() {
        return TargetInstanceTypeRightSizingMethod.fromValue(this.targetInstanceTypeRightSizingMethod);
    }

    public final String targetInstanceTypeRightSizingMethodAsString() {
        return this.targetInstanceTypeRightSizingMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyPrivateIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchIntoSourceInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.licensing());
        hashCode = 31 * hashCode + Objects.hashCode(this.postLaunchEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetInstanceTypeRightSizingMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfigurationTemplate)) {
            return false;
        }
        LaunchConfigurationTemplate other = (LaunchConfigurationTemplate)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.copyPrivateIp(), other.copyPrivateIp()) && Objects.equals(this.copyTags(), other.copyTags()) && Objects.equals(this.exportBucketArn(), other.exportBucketArn()) && Objects.equals(this.launchConfigurationTemplateID(), other.launchConfigurationTemplateID()) && Objects.equals(this.launchDispositionAsString(), other.launchDispositionAsString()) && Objects.equals(this.launchIntoSourceInstance(), other.launchIntoSourceInstance()) && Objects.equals(this.licensing(), other.licensing()) && Objects.equals(this.postLaunchEnabled(), other.postLaunchEnabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.targetInstanceTypeRightSizingMethodAsString(), other.targetInstanceTypeRightSizingMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchConfigurationTemplate").add("Arn", (Object)this.arn()).add("CopyPrivateIp", (Object)this.copyPrivateIp()).add("CopyTags", (Object)this.copyTags()).add("ExportBucketArn", (Object)this.exportBucketArn()).add("LaunchConfigurationTemplateID", (Object)this.launchConfigurationTemplateID()).add("LaunchDisposition", (Object)this.launchDispositionAsString()).add("LaunchIntoSourceInstance", (Object)this.launchIntoSourceInstance()).add("Licensing", (Object)this.licensing()).add("PostLaunchEnabled", (Object)this.postLaunchEnabled()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("TargetInstanceTypeRightSizingMethod", (Object)this.targetInstanceTypeRightSizingMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "copyPrivateIp": {
                return Optional.ofNullable(clazz.cast(this.copyPrivateIp()));
            }
            case "copyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "exportBucketArn": {
                return Optional.ofNullable(clazz.cast(this.exportBucketArn()));
            }
            case "launchConfigurationTemplateID": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationTemplateID()));
            }
            case "launchDisposition": {
                return Optional.ofNullable(clazz.cast(this.launchDispositionAsString()));
            }
            case "launchIntoSourceInstance": {
                return Optional.ofNullable(clazz.cast(this.launchIntoSourceInstance()));
            }
            case "licensing": {
                return Optional.ofNullable(clazz.cast(this.licensing()));
            }
            case "postLaunchEnabled": {
                return Optional.ofNullable(clazz.cast(this.postLaunchEnabled()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "targetInstanceTypeRightSizingMethod": {
                return Optional.ofNullable(clazz.cast(this.targetInstanceTypeRightSizingMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("copyPrivateIp", COPY_PRIVATE_IP_FIELD);
        map.put("copyTags", COPY_TAGS_FIELD);
        map.put("exportBucketArn", EXPORT_BUCKET_ARN_FIELD);
        map.put("launchConfigurationTemplateID", LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD);
        map.put("launchDisposition", LAUNCH_DISPOSITION_FIELD);
        map.put("launchIntoSourceInstance", LAUNCH_INTO_SOURCE_INSTANCE_FIELD);
        map.put("licensing", LICENSING_FIELD);
        map.put("postLaunchEnabled", POST_LAUNCH_ENABLED_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("targetInstanceTypeRightSizingMethod", TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchConfigurationTemplate, T> g) {
        return obj -> g.apply((LaunchConfigurationTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Boolean copyPrivateIp;
        private Boolean copyTags;
        private String exportBucketArn;
        private String launchConfigurationTemplateID;
        private String launchDisposition;
        private Boolean launchIntoSourceInstance;
        private Licensing licensing;
        private Boolean postLaunchEnabled;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String targetInstanceTypeRightSizingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchConfigurationTemplate model) {
            this.arn(model.arn);
            this.copyPrivateIp(model.copyPrivateIp);
            this.copyTags(model.copyTags);
            this.exportBucketArn(model.exportBucketArn);
            this.launchConfigurationTemplateID(model.launchConfigurationTemplateID);
            this.launchDisposition(model.launchDisposition);
            this.launchIntoSourceInstance(model.launchIntoSourceInstance);
            this.licensing(model.licensing);
            this.postLaunchEnabled(model.postLaunchEnabled);
            this.tags(model.tags);
            this.targetInstanceTypeRightSizingMethod(model.targetInstanceTypeRightSizingMethod);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getCopyPrivateIp() {
            return this.copyPrivateIp;
        }

        public final void setCopyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
        }

        @Override
        public final Builder copyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
            return this;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final String getExportBucketArn() {
            return this.exportBucketArn;
        }

        public final void setExportBucketArn(String exportBucketArn) {
            this.exportBucketArn = exportBucketArn;
        }

        @Override
        public final Builder exportBucketArn(String exportBucketArn) {
            this.exportBucketArn = exportBucketArn;
            return this;
        }

        public final String getLaunchConfigurationTemplateID() {
            return this.launchConfigurationTemplateID;
        }

        public final void setLaunchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
        }

        @Override
        public final Builder launchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
            return this;
        }

        public final String getLaunchDisposition() {
            return this.launchDisposition;
        }

        public final void setLaunchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
        }

        @Override
        public final Builder launchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
            return this;
        }

        @Override
        public final Builder launchDisposition(LaunchDisposition launchDisposition) {
            this.launchDisposition(launchDisposition == null ? null : launchDisposition.toString());
            return this;
        }

        public final Boolean getLaunchIntoSourceInstance() {
            return this.launchIntoSourceInstance;
        }

        public final void setLaunchIntoSourceInstance(Boolean launchIntoSourceInstance) {
            this.launchIntoSourceInstance = launchIntoSourceInstance;
        }

        @Override
        public final Builder launchIntoSourceInstance(Boolean launchIntoSourceInstance) {
            this.launchIntoSourceInstance = launchIntoSourceInstance;
            return this;
        }

        public final Licensing.Builder getLicensing() {
            return this.licensing != null ? this.licensing.toBuilder() : null;
        }

        public final void setLicensing(Licensing.BuilderImpl licensing) {
            this.licensing = licensing != null ? licensing.build() : null;
        }

        @Override
        public final Builder licensing(Licensing licensing) {
            this.licensing = licensing;
            return this;
        }

        public final Boolean getPostLaunchEnabled() {
            return this.postLaunchEnabled;
        }

        public final void setPostLaunchEnabled(Boolean postLaunchEnabled) {
            this.postLaunchEnabled = postLaunchEnabled;
        }

        @Override
        public final Builder postLaunchEnabled(Boolean postLaunchEnabled) {
            this.postLaunchEnabled = postLaunchEnabled;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getTargetInstanceTypeRightSizingMethod() {
            return this.targetInstanceTypeRightSizingMethod;
        }

        public final void setTargetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
            return this;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod(targetInstanceTypeRightSizingMethod == null ? null : targetInstanceTypeRightSizingMethod.toString());
            return this;
        }

        public LaunchConfigurationTemplate build() {
            return new LaunchConfigurationTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchConfigurationTemplate> {
        public Builder arn(String var1);

        public Builder copyPrivateIp(Boolean var1);

        public Builder copyTags(Boolean var1);

        public Builder exportBucketArn(String var1);

        public Builder launchConfigurationTemplateID(String var1);

        public Builder launchDisposition(String var1);

        public Builder launchDisposition(LaunchDisposition var1);

        public Builder launchIntoSourceInstance(Boolean var1);

        public Builder licensing(Licensing var1);

        default public Builder licensing(Consumer<Licensing.Builder> licensing) {
            return this.licensing((Licensing)((Licensing.Builder)Licensing.builder().applyMutation(licensing)).build());
        }

        public Builder postLaunchEnabled(Boolean var1);

        public Builder tags(Map<String, String> var1);

        public Builder targetInstanceTypeRightSizingMethod(String var1);

        public Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod var1);
    }
}

