/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipatingResourceID
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipatingResourceID> {
    private static final SdkField<String> SOURCE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceNetworkID").getter(ParticipatingResourceID.getter(ParticipatingResourceID::sourceNetworkID)).setter(ParticipatingResourceID.setter(Builder::sourceNetworkID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworkID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NETWORK_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParticipatingResourceID.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceNetworkID;
    private final Type type;

    private ParticipatingResourceID(BuilderImpl builder) {
        this.sourceNetworkID = builder.sourceNetworkID;
        this.type = builder.type;
    }

    public final String sourceNetworkID() {
        return this.sourceNetworkID;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceNetworkID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipatingResourceID)) {
            return false;
        }
        ParticipatingResourceID other = (ParticipatingResourceID)obj;
        return Objects.equals(this.sourceNetworkID(), other.sourceNetworkID());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipatingResourceID").add("SourceNetworkID", (Object)this.sourceNetworkID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceNetworkID": {
                return Optional.ofNullable(clazz.cast(this.sourceNetworkID()));
            }
        }
        return Optional.empty();
    }

    public static ParticipatingResourceID fromSourceNetworkID(String sourceNetworkID) {
        return (ParticipatingResourceID)ParticipatingResourceID.builder().sourceNetworkID(sourceNetworkID).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("sourceNetworkID", SOURCE_NETWORK_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipatingResourceID, T> g) {
        return obj -> g.apply((ParticipatingResourceID)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SOURCE_NETWORK_ID,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String sourceNetworkID;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipatingResourceID model) {
            this.sourceNetworkID(model.sourceNetworkID);
        }

        public final String getSourceNetworkID() {
            return this.sourceNetworkID;
        }

        public final void setSourceNetworkID(String sourceNetworkID) {
            String oldValue = this.sourceNetworkID;
            this.sourceNetworkID = sourceNetworkID;
            this.handleUnionValueChange(Type.SOURCE_NETWORK_ID, oldValue, this.sourceNetworkID);
        }

        @Override
        public final Builder sourceNetworkID(String sourceNetworkID) {
            String oldValue = this.sourceNetworkID;
            this.sourceNetworkID = sourceNetworkID;
            this.handleUnionValueChange(Type.SOURCE_NETWORK_ID, oldValue, this.sourceNetworkID);
            return this;
        }

        public ParticipatingResourceID build() {
            return new ParticipatingResourceID(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipatingResourceID> {
        public Builder sourceNetworkID(String var1);
    }
}

