/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.drs.model.LaunchActionRun;
import software.amazon.awssdk.services.drs.model.LaunchActionRunsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchActionsStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchActionsStatus> {
    private static final SdkField<List<LaunchActionRun>> RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("runs").getter(LaunchActionsStatus.getter(LaunchActionsStatus::runs)).setter(LaunchActionsStatus.setter(Builder::runs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchActionRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SSM_AGENT_DISCOVERY_DATETIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ssmAgentDiscoveryDatetime").getter(LaunchActionsStatus.getter(LaunchActionsStatus::ssmAgentDiscoveryDatetime)).setter(LaunchActionsStatus.setter(Builder::ssmAgentDiscoveryDatetime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmAgentDiscoveryDatetime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNS_FIELD, SSM_AGENT_DISCOVERY_DATETIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchActionsStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<LaunchActionRun> runs;
    private final String ssmAgentDiscoveryDatetime;

    private LaunchActionsStatus(BuilderImpl builder) {
        this.runs = builder.runs;
        this.ssmAgentDiscoveryDatetime = builder.ssmAgentDiscoveryDatetime;
    }

    public final boolean hasRuns() {
        return this.runs != null && !(this.runs instanceof SdkAutoConstructList);
    }

    public final List<LaunchActionRun> runs() {
        return this.runs;
    }

    public final String ssmAgentDiscoveryDatetime() {
        return this.ssmAgentDiscoveryDatetime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuns() ? this.runs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ssmAgentDiscoveryDatetime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchActionsStatus)) {
            return false;
        }
        LaunchActionsStatus other = (LaunchActionsStatus)obj;
        return this.hasRuns() == other.hasRuns() && Objects.equals(this.runs(), other.runs()) && Objects.equals(this.ssmAgentDiscoveryDatetime(), other.ssmAgentDiscoveryDatetime());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchActionsStatus").add("Runs", this.hasRuns() ? this.runs() : null).add("SsmAgentDiscoveryDatetime", (Object)this.ssmAgentDiscoveryDatetime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "runs": {
                return Optional.ofNullable(clazz.cast(this.runs()));
            }
            case "ssmAgentDiscoveryDatetime": {
                return Optional.ofNullable(clazz.cast(this.ssmAgentDiscoveryDatetime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("runs", RUNS_FIELD);
        map.put("ssmAgentDiscoveryDatetime", SSM_AGENT_DISCOVERY_DATETIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchActionsStatus, T> g) {
        return obj -> g.apply((LaunchActionsStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LaunchActionRun> runs = DefaultSdkAutoConstructList.getInstance();
        private String ssmAgentDiscoveryDatetime;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchActionsStatus model) {
            this.runs(model.runs);
            this.ssmAgentDiscoveryDatetime(model.ssmAgentDiscoveryDatetime);
        }

        public final List<LaunchActionRun.Builder> getRuns() {
            List<LaunchActionRun.Builder> result = LaunchActionRunsCopier.copyToBuilder(this.runs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuns(Collection<LaunchActionRun.BuilderImpl> runs) {
            this.runs = LaunchActionRunsCopier.copyFromBuilder(runs);
        }

        @Override
        public final Builder runs(Collection<LaunchActionRun> runs) {
            this.runs = LaunchActionRunsCopier.copy(runs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(LaunchActionRun ... runs) {
            this.runs(Arrays.asList(runs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(Consumer<LaunchActionRun.Builder> ... runs) {
            this.runs(Stream.of(runs).map(c -> (LaunchActionRun)((LaunchActionRun.Builder)LaunchActionRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSsmAgentDiscoveryDatetime() {
            return this.ssmAgentDiscoveryDatetime;
        }

        public final void setSsmAgentDiscoveryDatetime(String ssmAgentDiscoveryDatetime) {
            this.ssmAgentDiscoveryDatetime = ssmAgentDiscoveryDatetime;
        }

        @Override
        public final Builder ssmAgentDiscoveryDatetime(String ssmAgentDiscoveryDatetime) {
            this.ssmAgentDiscoveryDatetime = ssmAgentDiscoveryDatetime;
            return this;
        }

        public LaunchActionsStatus build() {
            return new LaunchActionsStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchActionsStatus> {
        public Builder runs(Collection<LaunchActionRun> var1);

        public Builder runs(LaunchActionRun ... var1);

        public Builder runs(Consumer<LaunchActionRun.Builder> ... var1);

        public Builder ssmAgentDiscoveryDatetime(String var1);
    }
}

