/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.drs.model.DrsRequest;
import software.amazon.awssdk.services.drs.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSourceNetworkRequest
extends DrsRequest
implements ToCopyableBuilder<Builder, CreateSourceNetworkRequest> {
    private static final SdkField<String> ORIGIN_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originAccountID").getter(CreateSourceNetworkRequest.getter(CreateSourceNetworkRequest::originAccountID)).setter(CreateSourceNetworkRequest.setter(Builder::originAccountID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originAccountID").build()}).build();
    private static final SdkField<String> ORIGIN_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originRegion").getter(CreateSourceNetworkRequest.getter(CreateSourceNetworkRequest::originRegion)).setter(CreateSourceNetworkRequest.setter(Builder::originRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originRegion").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSourceNetworkRequest.getter(CreateSourceNetworkRequest::tags)).setter(CreateSourceNetworkRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcID").getter(CreateSourceNetworkRequest.getter(CreateSourceNetworkRequest::vpcID)).setter(CreateSourceNetworkRequest.setter(Builder::vpcID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ACCOUNT_ID_FIELD, ORIGIN_REGION_FIELD, TAGS_FIELD, VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSourceNetworkRequest.memberNameToFieldInitializer();
    private final String originAccountID;
    private final String originRegion;
    private final Map<String, String> tags;
    private final String vpcID;

    private CreateSourceNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.originAccountID = builder.originAccountID;
        this.originRegion = builder.originRegion;
        this.tags = builder.tags;
        this.vpcID = builder.vpcID;
    }

    public final String originAccountID() {
        return this.originAccountID;
    }

    public final String originRegion() {
        return this.originRegion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String vpcID() {
        return this.vpcID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.originAccountID());
        hashCode = 31 * hashCode + Objects.hashCode(this.originRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSourceNetworkRequest)) {
            return false;
        }
        CreateSourceNetworkRequest other = (CreateSourceNetworkRequest)((Object)obj);
        return Objects.equals(this.originAccountID(), other.originAccountID()) && Objects.equals(this.originRegion(), other.originRegion()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcID(), other.vpcID());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSourceNetworkRequest").add("OriginAccountID", (Object)this.originAccountID()).add("OriginRegion", (Object)this.originRegion()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("VpcID", (Object)this.vpcID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "originAccountID": {
                return Optional.ofNullable(clazz.cast(this.originAccountID()));
            }
            case "originRegion": {
                return Optional.ofNullable(clazz.cast(this.originRegion()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "vpcID": {
                return Optional.ofNullable(clazz.cast(this.vpcID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("originAccountID", ORIGIN_ACCOUNT_ID_FIELD);
        map.put("originRegion", ORIGIN_REGION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("vpcID", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSourceNetworkRequest, T> g) {
        return obj -> g.apply((CreateSourceNetworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DrsRequest.BuilderImpl
    implements Builder {
        private String originAccountID;
        private String originRegion;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String vpcID;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSourceNetworkRequest model) {
            super(model);
            this.originAccountID(model.originAccountID);
            this.originRegion(model.originRegion);
            this.tags(model.tags);
            this.vpcID(model.vpcID);
        }

        public final String getOriginAccountID() {
            return this.originAccountID;
        }

        public final void setOriginAccountID(String originAccountID) {
            this.originAccountID = originAccountID;
        }

        @Override
        public final Builder originAccountID(String originAccountID) {
            this.originAccountID = originAccountID;
            return this;
        }

        public final String getOriginRegion() {
            return this.originRegion;
        }

        public final void setOriginRegion(String originRegion) {
            this.originRegion = originRegion;
        }

        @Override
        public final Builder originRegion(String originRegion) {
            this.originRegion = originRegion;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getVpcID() {
            return this.vpcID;
        }

        public final void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        @Override
        public final Builder vpcID(String vpcID) {
            this.vpcID = vpcID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSourceNetworkRequest build() {
            return new CreateSourceNetworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DrsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSourceNetworkRequest> {
        public Builder originAccountID(String var1);

        public Builder originRegion(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpcID(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

