/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.drs.model.RecoveryInstanceIDsCopier;
import software.amazon.awssdk.services.drs.model.SourceServerIDsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRecoveryInstancesRequestFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribeRecoveryInstancesRequestFilters> {
    private static final SdkField<List<String>> RECOVERY_INSTANCE_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recoveryInstanceIDs").getter(DescribeRecoveryInstancesRequestFilters.getter(DescribeRecoveryInstancesRequestFilters::recoveryInstanceIDs)).setter(DescribeRecoveryInstancesRequestFilters.setter(Builder::recoveryInstanceIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryInstanceIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SOURCE_SERVER_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceServerIDs").getter(DescribeRecoveryInstancesRequestFilters.getter(DescribeRecoveryInstancesRequestFilters::sourceServerIDs)).setter(DescribeRecoveryInstancesRequestFilters.setter(Builder::sourceServerIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_INSTANCE_I_DS_FIELD, SOURCE_SERVER_I_DS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRecoveryInstancesRequestFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> recoveryInstanceIDs;
    private final List<String> sourceServerIDs;

    private DescribeRecoveryInstancesRequestFilters(BuilderImpl builder) {
        this.recoveryInstanceIDs = builder.recoveryInstanceIDs;
        this.sourceServerIDs = builder.sourceServerIDs;
    }

    public final boolean hasRecoveryInstanceIDs() {
        return this.recoveryInstanceIDs != null && !(this.recoveryInstanceIDs instanceof SdkAutoConstructList);
    }

    public final List<String> recoveryInstanceIDs() {
        return this.recoveryInstanceIDs;
    }

    public final boolean hasSourceServerIDs() {
        return this.sourceServerIDs != null && !(this.sourceServerIDs instanceof SdkAutoConstructList);
    }

    public final List<String> sourceServerIDs() {
        return this.sourceServerIDs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecoveryInstanceIDs() ? this.recoveryInstanceIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceServerIDs() ? this.sourceServerIDs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecoveryInstancesRequestFilters)) {
            return false;
        }
        DescribeRecoveryInstancesRequestFilters other = (DescribeRecoveryInstancesRequestFilters)obj;
        return this.hasRecoveryInstanceIDs() == other.hasRecoveryInstanceIDs() && Objects.equals(this.recoveryInstanceIDs(), other.recoveryInstanceIDs()) && this.hasSourceServerIDs() == other.hasSourceServerIDs() && Objects.equals(this.sourceServerIDs(), other.sourceServerIDs());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRecoveryInstancesRequestFilters").add("RecoveryInstanceIDs", this.hasRecoveryInstanceIDs() ? this.recoveryInstanceIDs() : null).add("SourceServerIDs", this.hasSourceServerIDs() ? this.sourceServerIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recoveryInstanceIDs": {
                return Optional.ofNullable(clazz.cast(this.recoveryInstanceIDs()));
            }
            case "sourceServerIDs": {
                return Optional.ofNullable(clazz.cast(this.sourceServerIDs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("recoveryInstanceIDs", RECOVERY_INSTANCE_I_DS_FIELD);
        map.put("sourceServerIDs", SOURCE_SERVER_I_DS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecoveryInstancesRequestFilters, T> g) {
        return obj -> g.apply((DescribeRecoveryInstancesRequestFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> recoveryInstanceIDs = DefaultSdkAutoConstructList.getInstance();
        private List<String> sourceServerIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecoveryInstancesRequestFilters model) {
            this.recoveryInstanceIDs(model.recoveryInstanceIDs);
            this.sourceServerIDs(model.sourceServerIDs);
        }

        public final Collection<String> getRecoveryInstanceIDs() {
            if (this.recoveryInstanceIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recoveryInstanceIDs;
        }

        public final void setRecoveryInstanceIDs(Collection<String> recoveryInstanceIDs) {
            this.recoveryInstanceIDs = RecoveryInstanceIDsCopier.copy(recoveryInstanceIDs);
        }

        @Override
        public final Builder recoveryInstanceIDs(Collection<String> recoveryInstanceIDs) {
            this.recoveryInstanceIDs = RecoveryInstanceIDsCopier.copy(recoveryInstanceIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryInstanceIDs(String ... recoveryInstanceIDs) {
            this.recoveryInstanceIDs(Arrays.asList(recoveryInstanceIDs));
            return this;
        }

        public final Collection<String> getSourceServerIDs() {
            if (this.sourceServerIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceServerIDs;
        }

        public final void setSourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = SourceServerIDsCopier.copy(sourceServerIDs);
        }

        @Override
        public final Builder sourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = SourceServerIDsCopier.copy(sourceServerIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServerIDs(String ... sourceServerIDs) {
            this.sourceServerIDs(Arrays.asList(sourceServerIDs));
            return this;
        }

        public DescribeRecoveryInstancesRequestFilters build() {
            return new DescribeRecoveryInstancesRequestFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribeRecoveryInstancesRequestFilters> {
        public Builder recoveryInstanceIDs(Collection<String> var1);

        public Builder recoveryInstanceIDs(String ... var1);

        public Builder sourceServerIDs(Collection<String> var1);

        public Builder sourceServerIDs(String ... var1);
    }
}

