/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.drs.model.DataReplicationInitiationStep;
import software.amazon.awssdk.services.drs.model.DataReplicationInitiationStepsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataReplicationInitiation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataReplicationInitiation> {
    private static final SdkField<String> NEXT_ATTEMPT_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextAttemptDateTime").getter(DataReplicationInitiation.getter(DataReplicationInitiation::nextAttemptDateTime)).setter(DataReplicationInitiation.setter(Builder::nextAttemptDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextAttemptDateTime").build()}).build();
    private static final SdkField<String> START_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startDateTime").getter(DataReplicationInitiation.getter(DataReplicationInitiation::startDateTime)).setter(DataReplicationInitiation.setter(Builder::startDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateTime").build()}).build();
    private static final SdkField<List<DataReplicationInitiationStep>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("steps").getter(DataReplicationInitiation.getter(DataReplicationInitiation::steps)).setter(DataReplicationInitiation.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataReplicationInitiationStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_ATTEMPT_DATE_TIME_FIELD, START_DATE_TIME_FIELD, STEPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataReplicationInitiation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String nextAttemptDateTime;
    private final String startDateTime;
    private final List<DataReplicationInitiationStep> steps;

    private DataReplicationInitiation(BuilderImpl builder) {
        this.nextAttemptDateTime = builder.nextAttemptDateTime;
        this.startDateTime = builder.startDateTime;
        this.steps = builder.steps;
    }

    public final String nextAttemptDateTime() {
        return this.nextAttemptDateTime;
    }

    public final String startDateTime() {
        return this.startDateTime;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<DataReplicationInitiationStep> steps() {
        return this.steps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextAttemptDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataReplicationInitiation)) {
            return false;
        }
        DataReplicationInitiation other = (DataReplicationInitiation)obj;
        return Objects.equals(this.nextAttemptDateTime(), other.nextAttemptDateTime()) && Objects.equals(this.startDateTime(), other.startDateTime()) && this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps());
    }

    public final String toString() {
        return ToString.builder((String)"DataReplicationInitiation").add("NextAttemptDateTime", (Object)this.nextAttemptDateTime()).add("StartDateTime", (Object)this.startDateTime()).add("Steps", this.hasSteps() ? this.steps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextAttemptDateTime": {
                return Optional.ofNullable(clazz.cast(this.nextAttemptDateTime()));
            }
            case "startDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextAttemptDateTime", NEXT_ATTEMPT_DATE_TIME_FIELD);
        map.put("startDateTime", START_DATE_TIME_FIELD);
        map.put("steps", STEPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataReplicationInitiation, T> g) {
        return obj -> g.apply((DataReplicationInitiation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nextAttemptDateTime;
        private String startDateTime;
        private List<DataReplicationInitiationStep> steps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataReplicationInitiation model) {
            this.nextAttemptDateTime(model.nextAttemptDateTime);
            this.startDateTime(model.startDateTime);
            this.steps(model.steps);
        }

        public final String getNextAttemptDateTime() {
            return this.nextAttemptDateTime;
        }

        public final void setNextAttemptDateTime(String nextAttemptDateTime) {
            this.nextAttemptDateTime = nextAttemptDateTime;
        }

        @Override
        public final Builder nextAttemptDateTime(String nextAttemptDateTime) {
            this.nextAttemptDateTime = nextAttemptDateTime;
            return this;
        }

        public final String getStartDateTime() {
            return this.startDateTime;
        }

        public final void setStartDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final List<DataReplicationInitiationStep.Builder> getSteps() {
            List<DataReplicationInitiationStep.Builder> result = DataReplicationInitiationStepsCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<DataReplicationInitiationStep.BuilderImpl> steps) {
            this.steps = DataReplicationInitiationStepsCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<DataReplicationInitiationStep> steps) {
            this.steps = DataReplicationInitiationStepsCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(DataReplicationInitiationStep ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<DataReplicationInitiationStep.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (DataReplicationInitiationStep)((DataReplicationInitiationStep.Builder)DataReplicationInitiationStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DataReplicationInitiation build() {
            return new DataReplicationInitiation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataReplicationInitiation> {
        public Builder nextAttemptDateTime(String var1);

        public Builder startDateTime(String var1);

        public Builder steps(Collection<DataReplicationInitiationStep> var1);

        public Builder steps(DataReplicationInitiationStep ... var1);

        public Builder steps(Consumer<DataReplicationInitiationStep.Builder> ... var1);
    }
}

