/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsAsyncClient;
import software.amazon.awssdk.services.drs.internal.UserAgentUtils;
import software.amazon.awssdk.services.drs.model.LaunchAction;
import software.amazon.awssdk.services.drs.model.ListLaunchActionsRequest;
import software.amazon.awssdk.services.drs.model.ListLaunchActionsResponse;

public class ListLaunchActionsPublisher
implements SdkPublisher<ListLaunchActionsResponse> {
    private final DrsAsyncClient client;
    private final ListLaunchActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLaunchActionsPublisher(DrsAsyncClient client, ListLaunchActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLaunchActionsPublisher(DrsAsyncClient client, ListLaunchActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLaunchActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLaunchActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LaunchAction> items() {
        Function<ListLaunchActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLaunchActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLaunchActionsResponseFetcher
    implements AsyncPageFetcher<ListLaunchActionsResponse> {
        private ListLaunchActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLaunchActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLaunchActionsResponse> nextPage(ListLaunchActionsResponse previousPage) {
            if (previousPage == null) {
                return ListLaunchActionsPublisher.this.client.listLaunchActions(ListLaunchActionsPublisher.this.firstRequest);
            }
            return ListLaunchActionsPublisher.this.client.listLaunchActions((ListLaunchActionsRequest)((Object)ListLaunchActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

