/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.drs.model.ExtensionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StagingArea
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StagingArea> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(StagingArea.getter(StagingArea::errorMessage)).setter(StagingArea.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> STAGING_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stagingAccountID").getter(StagingArea.getter(StagingArea::stagingAccountID)).setter(StagingArea.setter(Builder::stagingAccountID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAccountID").build()}).build();
    private static final SdkField<String> STAGING_SOURCE_SERVER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stagingSourceServerArn").getter(StagingArea.getter(StagingArea::stagingSourceServerArn)).setter(StagingArea.setter(Builder::stagingSourceServerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingSourceServerArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(StagingArea.getter(StagingArea::statusAsString)).setter(StagingArea.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD, STAGING_ACCOUNT_ID_FIELD, STAGING_SOURCE_SERVER_ARN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("errorMessage", ERROR_MESSAGE_FIELD);
            this.put("stagingAccountID", STAGING_ACCOUNT_ID_FIELD);
            this.put("stagingSourceServerArn", STAGING_SOURCE_SERVER_ARN_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String errorMessage;
    private final String stagingAccountID;
    private final String stagingSourceServerArn;
    private final String status;

    private StagingArea(BuilderImpl builder) {
        this.errorMessage = builder.errorMessage;
        this.stagingAccountID = builder.stagingAccountID;
        this.stagingSourceServerArn = builder.stagingSourceServerArn;
        this.status = builder.status;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String stagingAccountID() {
        return this.stagingAccountID;
    }

    public final String stagingSourceServerArn() {
        return this.stagingSourceServerArn;
    }

    public final ExtensionStatus status() {
        return ExtensionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stagingAccountID());
        hashCode = 31 * hashCode + Objects.hashCode(this.stagingSourceServerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StagingArea)) {
            return false;
        }
        StagingArea other = (StagingArea)obj;
        return Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.stagingAccountID(), other.stagingAccountID()) && Objects.equals(this.stagingSourceServerArn(), other.stagingSourceServerArn()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StagingArea").add("ErrorMessage", (Object)this.errorMessage()).add("StagingAccountID", (Object)this.stagingAccountID()).add("StagingSourceServerArn", (Object)this.stagingSourceServerArn()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "stagingAccountID": {
                return Optional.ofNullable(clazz.cast(this.stagingAccountID()));
            }
            case "stagingSourceServerArn": {
                return Optional.ofNullable(clazz.cast(this.stagingSourceServerArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StagingArea, T> g) {
        return obj -> g.apply((StagingArea)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorMessage;
        private String stagingAccountID;
        private String stagingSourceServerArn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StagingArea model) {
            this.errorMessage(model.errorMessage);
            this.stagingAccountID(model.stagingAccountID);
            this.stagingSourceServerArn(model.stagingSourceServerArn);
            this.status(model.status);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getStagingAccountID() {
            return this.stagingAccountID;
        }

        public final void setStagingAccountID(String stagingAccountID) {
            this.stagingAccountID = stagingAccountID;
        }

        @Override
        public final Builder stagingAccountID(String stagingAccountID) {
            this.stagingAccountID = stagingAccountID;
            return this;
        }

        public final String getStagingSourceServerArn() {
            return this.stagingSourceServerArn;
        }

        public final void setStagingSourceServerArn(String stagingSourceServerArn) {
            this.stagingSourceServerArn = stagingSourceServerArn;
        }

        @Override
        public final Builder stagingSourceServerArn(String stagingSourceServerArn) {
            this.stagingSourceServerArn = stagingSourceServerArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExtensionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public StagingArea build() {
            return new StagingArea(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StagingArea> {
        public Builder errorMessage(String var1);

        public Builder stagingAccountID(String var1);

        public Builder stagingSourceServerArn(String var1);

        public Builder status(String var1);

        public Builder status(ExtensionStatus var1);
    }
}

