/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LaunchActionCategory {
    MONITORING("MONITORING"),
    VALIDATION("VALIDATION"),
    CONFIGURATION("CONFIGURATION"),
    SECURITY("SECURITY"),
    OTHER("OTHER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LaunchActionCategory> VALUE_MAP;
    private final String value;

    private LaunchActionCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LaunchActionCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LaunchActionCategory> knownValues() {
        EnumSet<LaunchActionCategory> knownValues = EnumSet.allOf(LaunchActionCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LaunchActionCategory.class, LaunchActionCategory::toString);
    }
}

