/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsAsyncClient;
import software.amazon.awssdk.services.drs.internal.UserAgentUtils;
import software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesRequest;
import software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesResponse;
import software.amazon.awssdk.services.drs.model.RecoveryInstance;

public class DescribeRecoveryInstancesPublisher
implements SdkPublisher<DescribeRecoveryInstancesResponse> {
    private final DrsAsyncClient client;
    private final DescribeRecoveryInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRecoveryInstancesPublisher(DrsAsyncClient client, DescribeRecoveryInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRecoveryInstancesPublisher(DrsAsyncClient client, DescribeRecoveryInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRecoveryInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRecoveryInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecoveryInstance> items() {
        Function<DescribeRecoveryInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRecoveryInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRecoveryInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeRecoveryInstancesResponse> {
        private DescribeRecoveryInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRecoveryInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRecoveryInstancesResponse> nextPage(DescribeRecoveryInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRecoveryInstancesPublisher.this.client.describeRecoveryInstances(DescribeRecoveryInstancesPublisher.this.firstRequest);
            }
            return DescribeRecoveryInstancesPublisher.this.client.describeRecoveryInstances((DescribeRecoveryInstancesRequest)((Object)DescribeRecoveryInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

