/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EC2InstanceState {
    PENDING("PENDING"),
    RUNNING("RUNNING"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    SHUTTING_DOWN("SHUTTING-DOWN"),
    TERMINATED("TERMINATED"),
    NOT_FOUND("NOT_FOUND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EC2InstanceState> VALUE_MAP;
    private final String value;

    private EC2InstanceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EC2InstanceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EC2InstanceState> knownValues() {
        EnumSet<EC2InstanceState> knownValues = EnumSet.allOf(EC2InstanceState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EC2InstanceState.class, EC2InstanceState::toString);
    }
}

