/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VolumeStatus {
    REGULAR("REGULAR"),
    CONTAINS_MARKETPLACE_PRODUCT_CODES("CONTAINS_MARKETPLACE_PRODUCT_CODES"),
    MISSING_VOLUME_ATTRIBUTES("MISSING_VOLUME_ATTRIBUTES"),
    MISSING_VOLUME_ATTRIBUTES_AND_PRECHECK_UNAVAILABLE("MISSING_VOLUME_ATTRIBUTES_AND_PRECHECK_UNAVAILABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VolumeStatus> VALUE_MAP;
    private final String value;

    private VolumeStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VolumeStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VolumeStatus> knownValues() {
        EnumSet<VolumeStatus> knownValues = EnumSet.allOf(VolumeStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VolumeStatus.class, VolumeStatus::toString);
    }
}

