/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.drs.model.LaunchStatus;
import software.amazon.awssdk.services.drs.model.ParticipatingResourceID;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipatingResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipatingResource> {
    private static final SdkField<String> LAUNCH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchStatus").getter(ParticipatingResource.getter(ParticipatingResource::launchStatusAsString)).setter(ParticipatingResource.setter(Builder::launchStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchStatus").build()}).build();
    private static final SdkField<ParticipatingResourceID> PARTICIPATING_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("participatingResourceID").getter(ParticipatingResource.getter(ParticipatingResource::participatingResourceID)).setter(ParticipatingResource.setter(Builder::participatingResourceID)).constructor(ParticipatingResourceID::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participatingResourceID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_STATUS_FIELD, PARTICIPATING_RESOURCE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String launchStatus;
    private final ParticipatingResourceID participatingResourceID;

    private ParticipatingResource(BuilderImpl builder) {
        this.launchStatus = builder.launchStatus;
        this.participatingResourceID = builder.participatingResourceID;
    }

    public final LaunchStatus launchStatus() {
        return LaunchStatus.fromValue(this.launchStatus);
    }

    public final String launchStatusAsString() {
        return this.launchStatus;
    }

    public final ParticipatingResourceID participatingResourceID() {
        return this.participatingResourceID;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.participatingResourceID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipatingResource)) {
            return false;
        }
        ParticipatingResource other = (ParticipatingResource)obj;
        return Objects.equals(this.launchStatusAsString(), other.launchStatusAsString()) && Objects.equals(this.participatingResourceID(), other.participatingResourceID());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipatingResource").add("LaunchStatus", (Object)this.launchStatusAsString()).add("ParticipatingResourceID", (Object)this.participatingResourceID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "launchStatus": {
                return Optional.ofNullable(clazz.cast(this.launchStatusAsString()));
            }
            case "participatingResourceID": {
                return Optional.ofNullable(clazz.cast(this.participatingResourceID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParticipatingResource, T> g) {
        return obj -> g.apply((ParticipatingResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String launchStatus;
        private ParticipatingResourceID participatingResourceID;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipatingResource model) {
            this.launchStatus(model.launchStatus);
            this.participatingResourceID(model.participatingResourceID);
        }

        public final String getLaunchStatus() {
            return this.launchStatus;
        }

        public final void setLaunchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
        }

        @Override
        public final Builder launchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
            return this;
        }

        @Override
        public final Builder launchStatus(LaunchStatus launchStatus) {
            this.launchStatus(launchStatus == null ? null : launchStatus.toString());
            return this;
        }

        public final ParticipatingResourceID.Builder getParticipatingResourceID() {
            return this.participatingResourceID != null ? this.participatingResourceID.toBuilder() : null;
        }

        public final void setParticipatingResourceID(ParticipatingResourceID.BuilderImpl participatingResourceID) {
            this.participatingResourceID = participatingResourceID != null ? participatingResourceID.build() : null;
        }

        @Override
        public final Builder participatingResourceID(ParticipatingResourceID participatingResourceID) {
            this.participatingResourceID = participatingResourceID;
            return this;
        }

        public ParticipatingResource build() {
            return new ParticipatingResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipatingResource> {
        public Builder launchStatus(String var1);

        public Builder launchStatus(LaunchStatus var1);

        public Builder participatingResourceID(ParticipatingResourceID var1);

        default public Builder participatingResourceID(Consumer<ParticipatingResourceID.Builder> participatingResourceID) {
            return this.participatingResourceID((ParticipatingResourceID)((ParticipatingResourceID.Builder)ParticipatingResourceID.builder().applyMutation(participatingResourceID)).build());
        }
    }
}

