/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InitiatedBy {
    START_RECOVERY("START_RECOVERY"),
    START_DRILL("START_DRILL"),
    FAILBACK("FAILBACK"),
    DIAGNOSTIC("DIAGNOSTIC"),
    TERMINATE_RECOVERY_INSTANCES("TERMINATE_RECOVERY_INSTANCES"),
    TARGET_ACCOUNT("TARGET_ACCOUNT"),
    CREATE_NETWORK_RECOVERY("CREATE_NETWORK_RECOVERY"),
    UPDATE_NETWORK_RECOVERY("UPDATE_NETWORK_RECOVERY"),
    ASSOCIATE_NETWORK_RECOVERY("ASSOCIATE_NETWORK_RECOVERY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InitiatedBy> VALUE_MAP;
    private final String value;

    private InitiatedBy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InitiatedBy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InitiatedBy> knownValues() {
        EnumSet<InitiatedBy> knownValues = EnumSet.allOf(InitiatedBy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InitiatedBy.class, InitiatedBy::toString);
    }
}

