/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.drs.DefaultDrsAsyncClient;
import software.amazon.awssdk.services.drs.DefaultDrsBaseClientBuilder;
import software.amazon.awssdk.services.drs.DrsAsyncClient;
import software.amazon.awssdk.services.drs.DrsAsyncClientBuilder;
import software.amazon.awssdk.services.drs.DrsServiceClientConfiguration;
import software.amazon.awssdk.services.drs.endpoints.DrsEndpointProvider;

@SdkInternalApi
final class DefaultDrsAsyncClientBuilder
extends DefaultDrsBaseClientBuilder<DrsAsyncClientBuilder, DrsAsyncClient>
implements DrsAsyncClientBuilder {
    DefaultDrsAsyncClientBuilder() {
    }

    @Override
    public DefaultDrsAsyncClientBuilder endpointProvider(DrsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DrsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDrsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        DrsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDrsAsyncClient client = new DefaultDrsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DrsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DrsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

