/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum DataReplicationErrorString {
    AGENT_NOT_SEEN("AGENT_NOT_SEEN"),

    SNAPSHOTS_FAILURE("SNAPSHOTS_FAILURE"),

    NOT_CONVERGING("NOT_CONVERGING"),

    UNSTABLE_NETWORK("UNSTABLE_NETWORK"),

    FAILED_TO_CREATE_SECURITY_GROUP("FAILED_TO_CREATE_SECURITY_GROUP"),

    FAILED_TO_LAUNCH_REPLICATION_SERVER("FAILED_TO_LAUNCH_REPLICATION_SERVER"),

    FAILED_TO_BOOT_REPLICATION_SERVER("FAILED_TO_BOOT_REPLICATION_SERVER"),

    FAILED_TO_AUTHENTICATE_WITH_SERVICE("FAILED_TO_AUTHENTICATE_WITH_SERVICE"),

    FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE("FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE"),

    FAILED_TO_CREATE_STAGING_DISKS("FAILED_TO_CREATE_STAGING_DISKS"),

    FAILED_TO_ATTACH_STAGING_DISKS("FAILED_TO_ATTACH_STAGING_DISKS"),

    FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT("FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT"),

    FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER("FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER"),

    FAILED_TO_START_DATA_TRANSFER("FAILED_TO_START_DATA_TRANSFER"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataReplicationErrorString> VALUE_MAP = EnumUtils.uniqueIndex(
            DataReplicationErrorString.class, DataReplicationErrorString::toString);

    private final String value;

    private DataReplicationErrorString(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DataReplicationErrorString corresponding to the value
     */
    public static DataReplicationErrorString fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DataReplicationErrorString}s
     */
    public static Set<DataReplicationErrorString> knownValues() {
        Set<DataReplicationErrorString> knownValues = EnumSet.allOf(DataReplicationErrorString.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
