/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSourceNetworkResponse extends DrsResponse implements
        ToCopyableBuilder<CreateSourceNetworkResponse.Builder, CreateSourceNetworkResponse> {
    private static final SdkField<String> SOURCE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceNetworkID").getter(getter(CreateSourceNetworkResponse::sourceNetworkID))
            .setter(setter(Builder::sourceNetworkID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworkID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NETWORK_ID_FIELD));

    private final String sourceNetworkID;

    private CreateSourceNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.sourceNetworkID = builder.sourceNetworkID;
    }

    /**
     * <p>
     * ID of the created Source Network.
     * </p>
     * 
     * @return ID of the created Source Network.
     */
    public final String sourceNetworkID() {
        return sourceNetworkID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceNetworkID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSourceNetworkResponse)) {
            return false;
        }
        CreateSourceNetworkResponse other = (CreateSourceNetworkResponse) obj;
        return Objects.equals(sourceNetworkID(), other.sourceNetworkID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSourceNetworkResponse").add("SourceNetworkID", sourceNetworkID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceNetworkID":
            return Optional.ofNullable(clazz.cast(sourceNetworkID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSourceNetworkResponse, T> g) {
        return obj -> g.apply((CreateSourceNetworkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSourceNetworkResponse> {
        /**
         * <p>
         * ID of the created Source Network.
         * </p>
         * 
         * @param sourceNetworkID
         *        ID of the created Source Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceNetworkID(String sourceNetworkID);
    }

    static final class BuilderImpl extends DrsResponse.BuilderImpl implements Builder {
        private String sourceNetworkID;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSourceNetworkResponse model) {
            super(model);
            sourceNetworkID(model.sourceNetworkID);
        }

        public final String getSourceNetworkID() {
            return sourceNetworkID;
        }

        public final void setSourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
        }

        @Override
        public final Builder sourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
            return this;
        }

        @Override
        public CreateSourceNetworkResponse build() {
            return new CreateSourceNetworkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
