/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.drs.model.DescribeSourceNetworksRequestFiltersIDsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSourceNetworksRequestFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribeSourceNetworksRequestFilters> {
    private static final SdkField<String> ORIGIN_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originAccountID").getter(DescribeSourceNetworksRequestFilters.getter(DescribeSourceNetworksRequestFilters::originAccountID)).setter(DescribeSourceNetworksRequestFilters.setter(Builder::originAccountID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originAccountID").build()}).build();
    private static final SdkField<String> ORIGIN_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originRegion").getter(DescribeSourceNetworksRequestFilters.getter(DescribeSourceNetworksRequestFilters::originRegion)).setter(DescribeSourceNetworksRequestFilters.setter(Builder::originRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originRegion").build()}).build();
    private static final SdkField<List<String>> SOURCE_NETWORK_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceNetworkIDs").getter(DescribeSourceNetworksRequestFilters.getter(DescribeSourceNetworksRequestFilters::sourceNetworkIDs)).setter(DescribeSourceNetworksRequestFilters.setter(Builder::sourceNetworkIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworkIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ACCOUNT_ID_FIELD, ORIGIN_REGION_FIELD, SOURCE_NETWORK_I_DS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String originAccountID;
    private final String originRegion;
    private final List<String> sourceNetworkIDs;

    private DescribeSourceNetworksRequestFilters(BuilderImpl builder) {
        this.originAccountID = builder.originAccountID;
        this.originRegion = builder.originRegion;
        this.sourceNetworkIDs = builder.sourceNetworkIDs;
    }

    public final String originAccountID() {
        return this.originAccountID;
    }

    public final String originRegion() {
        return this.originRegion;
    }

    public final boolean hasSourceNetworkIDs() {
        return this.sourceNetworkIDs != null && !(this.sourceNetworkIDs instanceof SdkAutoConstructList);
    }

    public final List<String> sourceNetworkIDs() {
        return this.sourceNetworkIDs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.originAccountID());
        hashCode = 31 * hashCode + Objects.hashCode(this.originRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceNetworkIDs() ? this.sourceNetworkIDs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSourceNetworksRequestFilters)) {
            return false;
        }
        DescribeSourceNetworksRequestFilters other = (DescribeSourceNetworksRequestFilters)obj;
        return Objects.equals(this.originAccountID(), other.originAccountID()) && Objects.equals(this.originRegion(), other.originRegion()) && this.hasSourceNetworkIDs() == other.hasSourceNetworkIDs() && Objects.equals(this.sourceNetworkIDs(), other.sourceNetworkIDs());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSourceNetworksRequestFilters").add("OriginAccountID", (Object)this.originAccountID()).add("OriginRegion", (Object)this.originRegion()).add("SourceNetworkIDs", this.hasSourceNetworkIDs() ? this.sourceNetworkIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "originAccountID": {
                return Optional.ofNullable(clazz.cast(this.originAccountID()));
            }
            case "originRegion": {
                return Optional.ofNullable(clazz.cast(this.originRegion()));
            }
            case "sourceNetworkIDs": {
                return Optional.ofNullable(clazz.cast(this.sourceNetworkIDs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSourceNetworksRequestFilters, T> g) {
        return obj -> g.apply((DescribeSourceNetworksRequestFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String originAccountID;
        private String originRegion;
        private List<String> sourceNetworkIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSourceNetworksRequestFilters model) {
            this.originAccountID(model.originAccountID);
            this.originRegion(model.originRegion);
            this.sourceNetworkIDs(model.sourceNetworkIDs);
        }

        public final String getOriginAccountID() {
            return this.originAccountID;
        }

        public final void setOriginAccountID(String originAccountID) {
            this.originAccountID = originAccountID;
        }

        @Override
        public final Builder originAccountID(String originAccountID) {
            this.originAccountID = originAccountID;
            return this;
        }

        public final String getOriginRegion() {
            return this.originRegion;
        }

        public final void setOriginRegion(String originRegion) {
            this.originRegion = originRegion;
        }

        @Override
        public final Builder originRegion(String originRegion) {
            this.originRegion = originRegion;
            return this;
        }

        public final Collection<String> getSourceNetworkIDs() {
            if (this.sourceNetworkIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceNetworkIDs;
        }

        public final void setSourceNetworkIDs(Collection<String> sourceNetworkIDs) {
            this.sourceNetworkIDs = DescribeSourceNetworksRequestFiltersIDsCopier.copy(sourceNetworkIDs);
        }

        @Override
        public final Builder sourceNetworkIDs(Collection<String> sourceNetworkIDs) {
            this.sourceNetworkIDs = DescribeSourceNetworksRequestFiltersIDsCopier.copy(sourceNetworkIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceNetworkIDs(String ... sourceNetworkIDs) {
            this.sourceNetworkIDs(Arrays.asList(sourceNetworkIDs));
            return this;
        }

        public DescribeSourceNetworksRequestFilters build() {
            return new DescribeSourceNetworksRequestFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribeSourceNetworksRequestFilters> {
        public Builder originAccountID(String var1);

        public Builder originRegion(String var1);

        public Builder sourceNetworkIDs(Collection<String> var1);

        public Builder sourceNetworkIDs(String ... var1);
    }
}

