/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentificationHints
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentificationHints> {
    private static final SdkField<String> AWS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsInstanceID").getter(IdentificationHints.getter(IdentificationHints::awsInstanceID)).setter(IdentificationHints.setter(Builder::awsInstanceID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsInstanceID").build()}).build();
    private static final SdkField<String> FQDN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fqdn").getter(IdentificationHints.getter(IdentificationHints::fqdn)).setter(IdentificationHints.setter(Builder::fqdn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fqdn").build()}).build();
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostname").getter(IdentificationHints.getter(IdentificationHints::hostname)).setter(IdentificationHints.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<String> VM_WARE_UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vmWareUuid").getter(IdentificationHints.getter(IdentificationHints::vmWareUuid)).setter(IdentificationHints.setter(Builder::vmWareUuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmWareUuid").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_INSTANCE_ID_FIELD, FQDN_FIELD, HOSTNAME_FIELD, VM_WARE_UUID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String awsInstanceID;
    private final String fqdn;
    private final String hostname;
    private final String vmWareUuid;

    private IdentificationHints(BuilderImpl builder) {
        this.awsInstanceID = builder.awsInstanceID;
        this.fqdn = builder.fqdn;
        this.hostname = builder.hostname;
        this.vmWareUuid = builder.vmWareUuid;
    }

    public final String awsInstanceID() {
        return this.awsInstanceID;
    }

    public final String fqdn() {
        return this.fqdn;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final String vmWareUuid() {
        return this.vmWareUuid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsInstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(this.fqdn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmWareUuid());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentificationHints)) {
            return false;
        }
        IdentificationHints other = (IdentificationHints)obj;
        return Objects.equals(this.awsInstanceID(), other.awsInstanceID()) && Objects.equals(this.fqdn(), other.fqdn()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.vmWareUuid(), other.vmWareUuid());
    }

    public final String toString() {
        return ToString.builder((String)"IdentificationHints").add("AwsInstanceID", (Object)this.awsInstanceID()).add("Fqdn", (Object)this.fqdn()).add("Hostname", (Object)this.hostname()).add("VmWareUuid", (Object)this.vmWareUuid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsInstanceID": {
                return Optional.ofNullable(clazz.cast(this.awsInstanceID()));
            }
            case "fqdn": {
                return Optional.ofNullable(clazz.cast(this.fqdn()));
            }
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "vmWareUuid": {
                return Optional.ofNullable(clazz.cast(this.vmWareUuid()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentificationHints, T> g) {
        return obj -> g.apply((IdentificationHints)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsInstanceID;
        private String fqdn;
        private String hostname;
        private String vmWareUuid;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentificationHints model) {
            this.awsInstanceID(model.awsInstanceID);
            this.fqdn(model.fqdn);
            this.hostname(model.hostname);
            this.vmWareUuid(model.vmWareUuid);
        }

        public final String getAwsInstanceID() {
            return this.awsInstanceID;
        }

        public final void setAwsInstanceID(String awsInstanceID) {
            this.awsInstanceID = awsInstanceID;
        }

        @Override
        public final Builder awsInstanceID(String awsInstanceID) {
            this.awsInstanceID = awsInstanceID;
            return this;
        }

        public final String getFqdn() {
            return this.fqdn;
        }

        public final void setFqdn(String fqdn) {
            this.fqdn = fqdn;
        }

        @Override
        public final Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public final String getHostname() {
            return this.hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getVmWareUuid() {
            return this.vmWareUuid;
        }

        public final void setVmWareUuid(String vmWareUuid) {
            this.vmWareUuid = vmWareUuid;
        }

        @Override
        public final Builder vmWareUuid(String vmWareUuid) {
            this.vmWareUuid = vmWareUuid;
            return this;
        }

        public IdentificationHints build() {
            return new IdentificationHints(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentificationHints> {
        public Builder awsInstanceID(String var1);

        public Builder fqdn(String var1);

        public Builder hostname(String var1);

        public Builder vmWareUuid(String var1);
    }
}

