/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsClient;
import software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesRequest;
import software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesResponse;
import software.amazon.awssdk.services.drs.model.RecoveryInstance;

public class DescribeRecoveryInstancesIterable
implements SdkIterable<DescribeRecoveryInstancesResponse> {
    private final DrsClient client;
    private final DescribeRecoveryInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRecoveryInstancesIterable(DrsClient client, DescribeRecoveryInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeRecoveryInstancesResponseFetcher();
    }

    public Iterator<DescribeRecoveryInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecoveryInstance> items() {
        Function<DescribeRecoveryInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRecoveryInstancesResponseFetcher
    implements SyncPageFetcher<DescribeRecoveryInstancesResponse> {
        private DescribeRecoveryInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRecoveryInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRecoveryInstancesResponse nextPage(DescribeRecoveryInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRecoveryInstancesIterable.this.client.describeRecoveryInstances(DescribeRecoveryInstancesIterable.this.firstRequest);
            }
            return DescribeRecoveryInstancesIterable.this.client.describeRecoveryInstances((DescribeRecoveryInstancesRequest)((Object)DescribeRecoveryInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

