/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsAsyncClient;
import software.amazon.awssdk.services.drs.model.DescribeReplicationConfigurationTemplatesRequest;
import software.amazon.awssdk.services.drs.model.DescribeReplicationConfigurationTemplatesResponse;
import software.amazon.awssdk.services.drs.model.ReplicationConfigurationTemplate;

public class DescribeReplicationConfigurationTemplatesPublisher
implements SdkPublisher<DescribeReplicationConfigurationTemplatesResponse> {
    private final DrsAsyncClient client;
    private final DescribeReplicationConfigurationTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReplicationConfigurationTemplatesPublisher(DrsAsyncClient client, DescribeReplicationConfigurationTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReplicationConfigurationTemplatesPublisher(DrsAsyncClient client, DescribeReplicationConfigurationTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReplicationConfigurationTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReplicationConfigurationTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReplicationConfigurationTemplate> items() {
        Function<DescribeReplicationConfigurationTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeReplicationConfigurationTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeReplicationConfigurationTemplatesResponseFetcher
    implements AsyncPageFetcher<DescribeReplicationConfigurationTemplatesResponse> {
        private DescribeReplicationConfigurationTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationConfigurationTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeReplicationConfigurationTemplatesResponse> nextPage(DescribeReplicationConfigurationTemplatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationConfigurationTemplatesPublisher.this.client.describeReplicationConfigurationTemplates(DescribeReplicationConfigurationTemplatesPublisher.this.firstRequest);
            }
            return DescribeReplicationConfigurationTemplatesPublisher.this.client.describeReplicationConfigurationTemplates((DescribeReplicationConfigurationTemplatesRequest)((Object)DescribeReplicationConfigurationTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

