/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.drs.model.DrsRequest;
import software.amazon.awssdk.services.drs.model.RecoveryInstancesForTerminationRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TerminateRecoveryInstancesRequest
extends DrsRequest
implements ToCopyableBuilder<Builder, TerminateRecoveryInstancesRequest> {
    private static final SdkField<List<String>> RECOVERY_INSTANCE_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recoveryInstanceIDs").getter(TerminateRecoveryInstancesRequest.getter(TerminateRecoveryInstancesRequest::recoveryInstanceIDs)).setter(TerminateRecoveryInstancesRequest.setter(Builder::recoveryInstanceIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryInstanceIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_INSTANCE_I_DS_FIELD));
    private final List<String> recoveryInstanceIDs;

    private TerminateRecoveryInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.recoveryInstanceIDs = builder.recoveryInstanceIDs;
    }

    public final boolean hasRecoveryInstanceIDs() {
        return this.recoveryInstanceIDs != null && !(this.recoveryInstanceIDs instanceof SdkAutoConstructList);
    }

    public final List<String> recoveryInstanceIDs() {
        return this.recoveryInstanceIDs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecoveryInstanceIDs() ? this.recoveryInstanceIDs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateRecoveryInstancesRequest)) {
            return false;
        }
        TerminateRecoveryInstancesRequest other = (TerminateRecoveryInstancesRequest)((Object)obj);
        return this.hasRecoveryInstanceIDs() == other.hasRecoveryInstanceIDs() && Objects.equals(this.recoveryInstanceIDs(), other.recoveryInstanceIDs());
    }

    public final String toString() {
        return ToString.builder((String)"TerminateRecoveryInstancesRequest").add("RecoveryInstanceIDs", this.hasRecoveryInstanceIDs() ? this.recoveryInstanceIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recoveryInstanceIDs": {
                return Optional.ofNullable(clazz.cast(this.recoveryInstanceIDs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateRecoveryInstancesRequest, T> g) {
        return obj -> g.apply((TerminateRecoveryInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DrsRequest.BuilderImpl
    implements Builder {
        private List<String> recoveryInstanceIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateRecoveryInstancesRequest model) {
            super(model);
            this.recoveryInstanceIDs(model.recoveryInstanceIDs);
        }

        public final Collection<String> getRecoveryInstanceIDs() {
            if (this.recoveryInstanceIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recoveryInstanceIDs;
        }

        public final void setRecoveryInstanceIDs(Collection<String> recoveryInstanceIDs) {
            this.recoveryInstanceIDs = RecoveryInstancesForTerminationRequestCopier.copy(recoveryInstanceIDs);
        }

        @Override
        @Transient
        public final Builder recoveryInstanceIDs(Collection<String> recoveryInstanceIDs) {
            this.recoveryInstanceIDs = RecoveryInstancesForTerminationRequestCopier.copy(recoveryInstanceIDs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recoveryInstanceIDs(String ... recoveryInstanceIDs) {
            this.recoveryInstanceIDs(Arrays.asList(recoveryInstanceIDs));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TerminateRecoveryInstancesRequest build() {
            return new TerminateRecoveryInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DrsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TerminateRecoveryInstancesRequest> {
        public Builder recoveryInstanceIDs(Collection<String> var1);

        public Builder recoveryInstanceIDs(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

