/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.docdbelastic.model.DocDbElasticRequest;
import software.amazon.awssdk.services.docdbelastic.model.OptInType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplyPendingMaintenanceActionRequest
extends DocDbElasticRequest
implements ToCopyableBuilder<Builder, ApplyPendingMaintenanceActionRequest> {
    private static final SdkField<String> APPLY_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applyAction").getter(ApplyPendingMaintenanceActionRequest.getter(ApplyPendingMaintenanceActionRequest::applyAction)).setter(ApplyPendingMaintenanceActionRequest.setter(Builder::applyAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyAction").build()}).build();
    private static final SdkField<String> APPLY_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applyOn").getter(ApplyPendingMaintenanceActionRequest.getter(ApplyPendingMaintenanceActionRequest::applyOn)).setter(ApplyPendingMaintenanceActionRequest.setter(Builder::applyOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyOn").build()}).build();
    private static final SdkField<String> OPT_IN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("optInType").getter(ApplyPendingMaintenanceActionRequest.getter(ApplyPendingMaintenanceActionRequest::optInTypeAsString)).setter(ApplyPendingMaintenanceActionRequest.setter(Builder::optInType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optInType").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(ApplyPendingMaintenanceActionRequest.getter(ApplyPendingMaintenanceActionRequest::resourceArn)).setter(ApplyPendingMaintenanceActionRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLY_ACTION_FIELD, APPLY_ON_FIELD, OPT_IN_TYPE_FIELD, RESOURCE_ARN_FIELD));
    private final String applyAction;
    private final String applyOn;
    private final String optInType;
    private final String resourceArn;

    private ApplyPendingMaintenanceActionRequest(BuilderImpl builder) {
        super(builder);
        this.applyAction = builder.applyAction;
        this.applyOn = builder.applyOn;
        this.optInType = builder.optInType;
        this.resourceArn = builder.resourceArn;
    }

    public final String applyAction() {
        return this.applyAction;
    }

    public final String applyOn() {
        return this.applyOn;
    }

    public final OptInType optInType() {
        return OptInType.fromValue(this.optInType);
    }

    public final String optInTypeAsString() {
        return this.optInType;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applyAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.optInTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyPendingMaintenanceActionRequest)) {
            return false;
        }
        ApplyPendingMaintenanceActionRequest other = (ApplyPendingMaintenanceActionRequest)((Object)obj);
        return Objects.equals(this.applyAction(), other.applyAction()) && Objects.equals(this.applyOn(), other.applyOn()) && Objects.equals(this.optInTypeAsString(), other.optInTypeAsString()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"ApplyPendingMaintenanceActionRequest").add("ApplyAction", (Object)this.applyAction()).add("ApplyOn", (Object)this.applyOn()).add("OptInType", (Object)this.optInTypeAsString()).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applyAction": {
                return Optional.ofNullable(clazz.cast(this.applyAction()));
            }
            case "applyOn": {
                return Optional.ofNullable(clazz.cast(this.applyOn()));
            }
            case "optInType": {
                return Optional.ofNullable(clazz.cast(this.optInTypeAsString()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplyPendingMaintenanceActionRequest, T> g) {
        return obj -> g.apply((ApplyPendingMaintenanceActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbElasticRequest.BuilderImpl
    implements Builder {
        private String applyAction;
        private String applyOn;
        private String optInType;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyPendingMaintenanceActionRequest model) {
            super(model);
            this.applyAction(model.applyAction);
            this.applyOn(model.applyOn);
            this.optInType(model.optInType);
            this.resourceArn(model.resourceArn);
        }

        public final String getApplyAction() {
            return this.applyAction;
        }

        public final void setApplyAction(String applyAction) {
            this.applyAction = applyAction;
        }

        @Override
        public final Builder applyAction(String applyAction) {
            this.applyAction = applyAction;
            return this;
        }

        public final String getApplyOn() {
            return this.applyOn;
        }

        public final void setApplyOn(String applyOn) {
            this.applyOn = applyOn;
        }

        @Override
        public final Builder applyOn(String applyOn) {
            this.applyOn = applyOn;
            return this;
        }

        public final String getOptInType() {
            return this.optInType;
        }

        public final void setOptInType(String optInType) {
            this.optInType = optInType;
        }

        @Override
        public final Builder optInType(String optInType) {
            this.optInType = optInType;
            return this;
        }

        @Override
        public final Builder optInType(OptInType optInType) {
            this.optInType(optInType == null ? null : optInType.toString());
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ApplyPendingMaintenanceActionRequest build() {
            return new ApplyPendingMaintenanceActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DocDbElasticRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ApplyPendingMaintenanceActionRequest> {
        public Builder applyAction(String var1);

        public Builder applyOn(String var1);

        public Builder optInType(String var1);

        public Builder optInType(OptInType var1);

        public Builder resourceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

