/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.docdbelastic.model.DocDbElasticResponse;
import software.amazon.awssdk.services.docdbelastic.model.ResourcePendingMaintenanceAction;
import software.amazon.awssdk.services.docdbelastic.model.ResourcePendingMaintenanceActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPendingMaintenanceActionsResponse
extends DocDbElasticResponse
implements ToCopyableBuilder<Builder, ListPendingMaintenanceActionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPendingMaintenanceActionsResponse.getter(ListPendingMaintenanceActionsResponse::nextToken)).setter(ListPendingMaintenanceActionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ResourcePendingMaintenanceAction>> RESOURCE_PENDING_MAINTENANCE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourcePendingMaintenanceActions").getter(ListPendingMaintenanceActionsResponse.getter(ListPendingMaintenanceActionsResponse::resourcePendingMaintenanceActions)).setter(ListPendingMaintenanceActionsResponse.setter(Builder::resourcePendingMaintenanceActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcePendingMaintenanceActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePendingMaintenanceAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESOURCE_PENDING_MAINTENANCE_ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("resourcePendingMaintenanceActions", RESOURCE_PENDING_MAINTENANCE_ACTIONS_FIELD);
        }
    });
    private final String nextToken;
    private final List<ResourcePendingMaintenanceAction> resourcePendingMaintenanceActions;

    private ListPendingMaintenanceActionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resourcePendingMaintenanceActions = builder.resourcePendingMaintenanceActions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasResourcePendingMaintenanceActions() {
        return this.resourcePendingMaintenanceActions != null && !(this.resourcePendingMaintenanceActions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePendingMaintenanceAction> resourcePendingMaintenanceActions() {
        return this.resourcePendingMaintenanceActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourcePendingMaintenanceActions() ? this.resourcePendingMaintenanceActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPendingMaintenanceActionsResponse)) {
            return false;
        }
        ListPendingMaintenanceActionsResponse other = (ListPendingMaintenanceActionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasResourcePendingMaintenanceActions() == other.hasResourcePendingMaintenanceActions() && Objects.equals(this.resourcePendingMaintenanceActions(), other.resourcePendingMaintenanceActions());
    }

    public final String toString() {
        return ToString.builder((String)"ListPendingMaintenanceActionsResponse").add("NextToken", (Object)this.nextToken()).add("ResourcePendingMaintenanceActions", this.hasResourcePendingMaintenanceActions() ? this.resourcePendingMaintenanceActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "resourcePendingMaintenanceActions": {
                return Optional.ofNullable(clazz.cast(this.resourcePendingMaintenanceActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPendingMaintenanceActionsResponse, T> g) {
        return obj -> g.apply((ListPendingMaintenanceActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbElasticResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ResourcePendingMaintenanceAction> resourcePendingMaintenanceActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPendingMaintenanceActionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.resourcePendingMaintenanceActions(model.resourcePendingMaintenanceActions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResourcePendingMaintenanceAction.Builder> getResourcePendingMaintenanceActions() {
            List<ResourcePendingMaintenanceAction.Builder> result = ResourcePendingMaintenanceActionListCopier.copyToBuilder(this.resourcePendingMaintenanceActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourcePendingMaintenanceActions(Collection<ResourcePendingMaintenanceAction.BuilderImpl> resourcePendingMaintenanceActions) {
            this.resourcePendingMaintenanceActions = ResourcePendingMaintenanceActionListCopier.copyFromBuilder(resourcePendingMaintenanceActions);
        }

        @Override
        public final Builder resourcePendingMaintenanceActions(Collection<ResourcePendingMaintenanceAction> resourcePendingMaintenanceActions) {
            this.resourcePendingMaintenanceActions = ResourcePendingMaintenanceActionListCopier.copy(resourcePendingMaintenanceActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePendingMaintenanceActions(ResourcePendingMaintenanceAction ... resourcePendingMaintenanceActions) {
            this.resourcePendingMaintenanceActions(Arrays.asList(resourcePendingMaintenanceActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePendingMaintenanceActions(Consumer<ResourcePendingMaintenanceAction.Builder> ... resourcePendingMaintenanceActions) {
            this.resourcePendingMaintenanceActions(Stream.of(resourcePendingMaintenanceActions).map(c -> (ResourcePendingMaintenanceAction)((ResourcePendingMaintenanceAction.Builder)ResourcePendingMaintenanceAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPendingMaintenanceActionsResponse build() {
            return new ListPendingMaintenanceActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DocDbElasticResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPendingMaintenanceActionsResponse> {
        public Builder nextToken(String var1);

        public Builder resourcePendingMaintenanceActions(Collection<ResourcePendingMaintenanceAction> var1);

        public Builder resourcePendingMaintenanceActions(ResourcePendingMaintenanceAction ... var1);

        public Builder resourcePendingMaintenanceActions(Consumer<ResourcePendingMaintenanceAction.Builder> ... var1);
    }
}

