/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdbelastic.DocDbElasticAsyncClient;
import software.amazon.awssdk.services.docdbelastic.internal.UserAgentUtils;
import software.amazon.awssdk.services.docdbelastic.model.ClusterSnapshotInList;
import software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsResponse;

public class ListClusterSnapshotsPublisher
implements SdkPublisher<ListClusterSnapshotsResponse> {
    private final DocDbElasticAsyncClient client;
    private final ListClusterSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClusterSnapshotsPublisher(DocDbElasticAsyncClient client, ListClusterSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClusterSnapshotsPublisher(DocDbElasticAsyncClient client, ListClusterSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClusterSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClusterSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClusterSnapshotInList> snapshots() {
        Function<ListClusterSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshots() != null) {
                return response.snapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListClusterSnapshotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListClusterSnapshotsResponseFetcher
    implements AsyncPageFetcher<ListClusterSnapshotsResponse> {
        private ListClusterSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListClusterSnapshotsResponse> nextPage(ListClusterSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return ListClusterSnapshotsPublisher.this.client.listClusterSnapshots(ListClusterSnapshotsPublisher.this.firstRequest);
            }
            return ListClusterSnapshotsPublisher.this.client.listClusterSnapshots((ListClusterSnapshotsRequest)((Object)ListClusterSnapshotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

