/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo;
import software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfoListCopier;
import software.amazon.awssdk.services.docdb.model.DBSubnetGroup;
import software.amazon.awssdk.services.docdb.model.Endpoint;
import software.amazon.awssdk.services.docdb.model.LogTypeListCopier;
import software.amazon.awssdk.services.docdb.model.PendingModifiedValues;
import software.amazon.awssdk.services.docdb.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.docdb.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBInstance> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstance.getter(DBInstance::dbInstanceIdentifier)).setter(DBInstance.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstance.getter(DBInstance::dbInstanceClass)).setter(DBInstance.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstance.getter(DBInstance::engine)).setter(DBInstance.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> DB_INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstance.getter(DBInstance::dbInstanceStatus)).setter(DBInstance.setter(Builder::dbInstanceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceStatus").build()}).build();
    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DBInstance.getter(DBInstance::endpoint)).setter(DBInstance.setter(Builder::endpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Instant> INSTANCE_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DBInstance.getter(DBInstance::instanceCreateTime)).setter(DBInstance.setter(Builder::instanceCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstance.getter(DBInstance::preferredBackupWindow)).setter(DBInstance.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DBInstance.getter(DBInstance::backupRetentionPeriod)).setter(DBInstance.setter(Builder::backupRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build()}).build();
    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DBInstance.getter(DBInstance::vpcSecurityGroups)).setter(DBInstance.setter(Builder::vpcSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupMembership").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcSecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupMembership").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstance.getter(DBInstance::availabilityZone)).setter(DBInstance.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<DBSubnetGroup> DB_SUBNET_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DBInstance.getter(DBInstance::dbSubnetGroup)).setter(DBInstance.setter(Builder::dbSubnetGroup)).constructor(DBSubnetGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroup").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstance.getter(DBInstance::preferredMaintenanceWindow)).setter(DBInstance.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<PendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DBInstance.getter(DBInstance::pendingModifiedValues)).setter(DBInstance.setter(Builder::pendingModifiedValues)).constructor(PendingModifiedValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build()}).build();
    private static final SdkField<Instant> LATEST_RESTORABLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DBInstance.getter(DBInstance::latestRestorableTime)).setter(DBInstance.setter(Builder::latestRestorableTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestorableTime").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstance.getter(DBInstance::engineVersion)).setter(DBInstance.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DBInstance.getter(DBInstance::autoMinorVersionUpgrade)).setter(DBInstance.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DBInstance.getter(DBInstance::publiclyAccessible)).setter(DBInstance.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<List<DBInstanceStatusInfo>> STATUS_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DBInstance.getter(DBInstance::statusInfos)).setter(DBInstance.setter(Builder::statusInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusInfos").build(), ListTrait.builder().memberLocationName("DBInstanceStatusInfo").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBInstanceStatusInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceStatusInfo").build()}).build()).build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstance.getter(DBInstance::dbClusterIdentifier)).setter(DBInstance.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DBInstance.getter(DBInstance::storageEncrypted)).setter(DBInstance.setter(Builder::storageEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstance.getter(DBInstance::kmsKeyId)).setter(DBInstance.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstance.getter(DBInstance::dbiResourceId)).setter(DBInstance.setter(Builder::dbiResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()}).build();
    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DBInstance.getter(DBInstance::promotionTier)).setter(DBInstance.setter(Builder::promotionTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()}).build();
    private static final SdkField<String> DB_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DBInstance.getter(DBInstance::dbInstanceArn)).setter(DBInstance.setter(Builder::dbInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceArn").build()}).build();
    private static final SdkField<List<String>> ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DBInstance.getter(DBInstance::enabledCloudwatchLogsExports)).setter(DBInstance.setter(Builder::enabledCloudwatchLogsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledCloudwatchLogsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD, DB_INSTANCE_CLASS_FIELD, ENGINE_FIELD, DB_INSTANCE_STATUS_FIELD, ENDPOINT_FIELD, INSTANCE_CREATE_TIME_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, BACKUP_RETENTION_PERIOD_FIELD, VPC_SECURITY_GROUPS_FIELD, AVAILABILITY_ZONE_FIELD, DB_SUBNET_GROUP_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PENDING_MODIFIED_VALUES_FIELD, LATEST_RESTORABLE_TIME_FIELD, ENGINE_VERSION_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, PUBLICLY_ACCESSIBLE_FIELD, STATUS_INFOS_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, DBI_RESOURCE_ID_FIELD, PROMOTION_TIER_FIELD, DB_INSTANCE_ARN_FIELD, ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dbInstanceIdentifier;
    private final String dbInstanceClass;
    private final String engine;
    private final String dbInstanceStatus;
    private final Endpoint endpoint;
    private final Instant instanceCreateTime;
    private final String preferredBackupWindow;
    private final Integer backupRetentionPeriod;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private final String availabilityZone;
    private final DBSubnetGroup dbSubnetGroup;
    private final String preferredMaintenanceWindow;
    private final PendingModifiedValues pendingModifiedValues;
    private final Instant latestRestorableTime;
    private final String engineVersion;
    private final Boolean autoMinorVersionUpgrade;
    private final Boolean publiclyAccessible;
    private final List<DBInstanceStatusInfo> statusInfos;
    private final String dbClusterIdentifier;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String dbiResourceId;
    private final Integer promotionTier;
    private final String dbInstanceArn;
    private final List<String> enabledCloudwatchLogsExports;

    private DBInstance(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.engine = builder.engine;
        this.dbInstanceStatus = builder.dbInstanceStatus;
        this.endpoint = builder.endpoint;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.availabilityZone = builder.availabilityZone;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.latestRestorableTime = builder.latestRestorableTime;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.statusInfos = builder.statusInfos;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbiResourceId = builder.dbiResourceId;
        this.promotionTier = builder.promotionTier;
        this.dbInstanceArn = builder.dbInstanceArn;
        this.enabledCloudwatchLogsExports = builder.enabledCloudwatchLogsExports;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public String engine() {
        return this.engine;
    }

    public String dbInstanceStatus() {
        return this.dbInstanceStatus;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public Instant instanceCreateTime() {
        return this.instanceCreateTime;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public DBSubnetGroup dbSubnetGroup() {
        return this.dbSubnetGroup;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public PendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public Instant latestRestorableTime() {
        return this.latestRestorableTime;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public List<DBInstanceStatusInfo> statusInfos() {
        return this.statusInfos;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String dbiResourceId() {
        return this.dbiResourceId;
    }

    public Integer promotionTier() {
        return this.promotionTier;
    }

    public String dbInstanceArn() {
        return this.dbInstanceArn;
    }

    public List<String> enabledCloudwatchLogsExports() {
        return this.enabledCloudwatchLogsExports;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusInfos());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.promotionTier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledCloudwatchLogsExports());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstance)) {
            return false;
        }
        DBInstance other = (DBInstance)obj;
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.dbInstanceStatus(), other.dbInstanceStatus()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.instanceCreateTime(), other.instanceCreateTime()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.dbSubnetGroup(), other.dbSubnetGroup()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.pendingModifiedValues(), other.pendingModifiedValues()) && Objects.equals(this.latestRestorableTime(), other.latestRestorableTime()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.statusInfos(), other.statusInfos()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dbiResourceId(), other.dbiResourceId()) && Objects.equals(this.promotionTier(), other.promotionTier()) && Objects.equals(this.dbInstanceArn(), other.dbInstanceArn()) && Objects.equals(this.enabledCloudwatchLogsExports(), other.enabledCloudwatchLogsExports());
    }

    public String toString() {
        return ToString.builder((String)"DBInstance").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("Engine", (Object)this.engine()).add("DBInstanceStatus", (Object)this.dbInstanceStatus()).add("Endpoint", (Object)this.endpoint()).add("InstanceCreateTime", (Object)this.instanceCreateTime()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("VpcSecurityGroups", this.vpcSecurityGroups()).add("AvailabilityZone", (Object)this.availabilityZone()).add("DBSubnetGroup", (Object)this.dbSubnetGroup()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("PendingModifiedValues", (Object)this.pendingModifiedValues()).add("LatestRestorableTime", (Object)this.latestRestorableTime()).add("EngineVersion", (Object)this.engineVersion()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("StatusInfos", this.statusInfos()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DbiResourceId", (Object)this.dbiResourceId()).add("PromotionTier", (Object)this.promotionTier()).add("DBInstanceArn", (Object)this.dbInstanceArn()).add("EnabledCloudwatchLogsExports", this.enabledCloudwatchLogsExports()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "DBInstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceStatus()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "InstanceCreateTime": {
                return Optional.ofNullable(clazz.cast(this.instanceCreateTime()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "VpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroups()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "DBSubnetGroup": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroup()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "PendingModifiedValues": {
                return Optional.ofNullable(clazz.cast(this.pendingModifiedValues()));
            }
            case "LatestRestorableTime": {
                return Optional.ofNullable(clazz.cast(this.latestRestorableTime()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "StatusInfos": {
                return Optional.ofNullable(clazz.cast(this.statusInfos()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "DbiResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbiResourceId()));
            }
            case "PromotionTier": {
                return Optional.ofNullable(clazz.cast(this.promotionTier()));
            }
            case "DBInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceArn()));
            }
            case "EnabledCloudwatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enabledCloudwatchLogsExports()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBInstance, T> g) {
        return obj -> g.apply((DBInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String dbInstanceClass;
        private String engine;
        private String dbInstanceStatus;
        private Endpoint endpoint;
        private Instant instanceCreateTime;
        private String preferredBackupWindow;
        private Integer backupRetentionPeriod;
        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;
        private DBSubnetGroup dbSubnetGroup;
        private String preferredMaintenanceWindow;
        private PendingModifiedValues pendingModifiedValues;
        private Instant latestRestorableTime;
        private String engineVersion;
        private Boolean autoMinorVersionUpgrade;
        private Boolean publiclyAccessible;
        private List<DBInstanceStatusInfo> statusInfos = DefaultSdkAutoConstructList.getInstance();
        private String dbClusterIdentifier;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String dbiResourceId;
        private Integer promotionTier;
        private String dbInstanceArn;
        private List<String> enabledCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DBInstance model) {
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.dbInstanceClass(model.dbInstanceClass);
            this.engine(model.engine);
            this.dbInstanceStatus(model.dbInstanceStatus);
            this.endpoint(model.endpoint);
            this.instanceCreateTime(model.instanceCreateTime);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
            this.availabilityZone(model.availabilityZone);
            this.dbSubnetGroup(model.dbSubnetGroup);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.pendingModifiedValues(model.pendingModifiedValues);
            this.latestRestorableTime(model.latestRestorableTime);
            this.engineVersion(model.engineVersion);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.publiclyAccessible(model.publiclyAccessible);
            this.statusInfos(model.statusInfos);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.storageEncrypted(model.storageEncrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.dbiResourceId(model.dbiResourceId);
            this.promotionTier(model.promotionTier);
            this.dbInstanceArn(model.dbInstanceArn);
            this.enabledCloudwatchLogsExports(model.enabledCloudwatchLogsExports);
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getDbInstanceStatus() {
            return this.dbInstanceStatus;
        }

        @Override
        public final Builder dbInstanceStatus(String dbInstanceStatus) {
            this.dbInstanceStatus = dbInstanceStatus;
            return this;
        }

        public final void setDbInstanceStatus(String dbInstanceStatus) {
            this.dbInstanceStatus = dbInstanceStatus;
        }

        public final Endpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        public final Instant getInstanceCreateTime() {
            return this.instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final void setInstanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final Collection<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            return this.vpcSecurityGroups != null ? (Collection)this.vpcSecurityGroups.stream().map(VpcSecurityGroupMembership::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Stream.of(vpcSecurityGroups).map(c -> (VpcSecurityGroupMembership)((VpcSecurityGroupMembership.Builder)VpcSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final DBSubnetGroup.Builder getDbSubnetGroup() {
            return this.dbSubnetGroup != null ? this.dbSubnetGroup.toBuilder() : null;
        }

        @Override
        public final Builder dbSubnetGroup(DBSubnetGroup dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final void setDbSubnetGroup(DBSubnetGroup.BuilderImpl dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup != null ? dbSubnetGroup.build() : null;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final PendingModifiedValues.Builder getPendingModifiedValues() {
            return this.pendingModifiedValues != null ? this.pendingModifiedValues.toBuilder() : null;
        }

        @Override
        public final Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final void setPendingModifiedValues(PendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        public final Instant getLatestRestorableTime() {
            return this.latestRestorableTime;
        }

        @Override
        public final Builder latestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
            return this;
        }

        public final void setLatestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Collection<DBInstanceStatusInfo.Builder> getStatusInfos() {
            return this.statusInfos != null ? (Collection)this.statusInfos.stream().map(DBInstanceStatusInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statusInfos(Collection<DBInstanceStatusInfo> statusInfos) {
            this.statusInfos = DBInstanceStatusInfoListCopier.copy(statusInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusInfos(DBInstanceStatusInfo ... statusInfos) {
            this.statusInfos(Arrays.asList(statusInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusInfos(Consumer<DBInstanceStatusInfo.Builder> ... statusInfos) {
            this.statusInfos(Stream.of(statusInfos).map(c -> (DBInstanceStatusInfo)((DBInstanceStatusInfo.Builder)DBInstanceStatusInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatusInfos(Collection<DBInstanceStatusInfo.BuilderImpl> statusInfos) {
            this.statusInfos = DBInstanceStatusInfoListCopier.copyFromBuilder(statusInfos);
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getDbiResourceId() {
            return this.dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        public final Integer getPromotionTier() {
            return this.promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        public final String getDbInstanceArn() {
            return this.dbInstanceArn;
        }

        @Override
        public final Builder dbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
            return this;
        }

        public final void setDbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
        }

        public final Collection<String> getEnabledCloudwatchLogsExports() {
            return this.enabledCloudwatchLogsExports;
        }

        @Override
        public final Builder enabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledCloudwatchLogsExports(String ... enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports(Arrays.asList(enabledCloudwatchLogsExports));
            return this;
        }

        public final void setEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
        }

        public DBInstance build() {
            return new DBInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBInstance> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder engine(String var1);

        public Builder dbInstanceStatus(String var1);

        public Builder endpoint(Endpoint var1);

        default public Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return this.endpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder instanceCreateTime(Instant var1);

        public Builder preferredBackupWindow(String var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroups(VpcSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... var1);

        public Builder availabilityZone(String var1);

        public Builder dbSubnetGroup(DBSubnetGroup var1);

        default public Builder dbSubnetGroup(Consumer<DBSubnetGroup.Builder> dbSubnetGroup) {
            return this.dbSubnetGroup((DBSubnetGroup)((DBSubnetGroup.Builder)DBSubnetGroup.builder().applyMutation(dbSubnetGroup)).build());
        }

        public Builder preferredMaintenanceWindow(String var1);

        public Builder pendingModifiedValues(PendingModifiedValues var1);

        default public Builder pendingModifiedValues(Consumer<PendingModifiedValues.Builder> pendingModifiedValues) {
            return this.pendingModifiedValues((PendingModifiedValues)((PendingModifiedValues.Builder)PendingModifiedValues.builder().applyMutation(pendingModifiedValues)).build());
        }

        public Builder latestRestorableTime(Instant var1);

        public Builder engineVersion(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder statusInfos(Collection<DBInstanceStatusInfo> var1);

        public Builder statusInfos(DBInstanceStatusInfo ... var1);

        public Builder statusInfos(Consumer<DBInstanceStatusInfo.Builder> ... var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dbiResourceId(String var1);

        public Builder promotionTier(Integer var1);

        public Builder dbInstanceArn(String var1);

        public Builder enabledCloudwatchLogsExports(Collection<String> var1);

        public Builder enabledCloudwatchLogsExports(String ... var1);
    }
}

